/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.MetadataItem;
import com.azure.resourcemanager.datafactory.models.StoreWriteSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureFileStorageWriteSettings
extends StoreWriteSettings {
    private String type = "AzureFileStorageWriteSettings";

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public AzureFileStorageWriteSettings withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureFileStorageWriteSettings withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public AzureFileStorageWriteSettings withCopyBehavior(Object copyBehavior) {
        super.withCopyBehavior(copyBehavior);
        return this;
    }

    @Override
    public AzureFileStorageWriteSettings withMetadata(List<MetadataItem> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public void validate() {
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        if (this.copyBehavior() != null) {
            jsonWriter.writeUntypedField("copyBehavior", this.copyBehavior());
        }
        jsonWriter.writeArrayField("metadata", this.metadata(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureFileStorageWriteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFileStorageWriteSettings)jsonReader.readObject(reader -> {
            AzureFileStorageWriteSettings deserializedAzureFileStorageWriteSettings = new AzureFileStorageWriteSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureFileStorageWriteSettings.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedAzureFileStorageWriteSettings.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("copyBehavior".equals(fieldName)) {
                    deserializedAzureFileStorageWriteSettings.withCopyBehavior(reader.readUntyped());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    deserializedAzureFileStorageWriteSettings.withMetadata(metadata);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureFileStorageWriteSettings.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureFileStorageWriteSettings.withAdditionalProperties(additionalProperties);
            return deserializedAzureFileStorageWriteSettings;
        });
    }
}

