/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureDataLakeStoreReadSettings
extends StoreReadSettings {
    private String type = "AzureDataLakeStoreReadSettings";
    private Object recursive;
    private Object wildcardFolderPath;
    private Object wildcardFileName;
    private Object fileListPath;
    private Object listAfter;
    private Object listBefore;
    private Object enablePartitionDiscovery;
    private Object partitionRootPath;
    private Object deleteFilesAfterCompletion;
    private Object modifiedDatetimeStart;
    private Object modifiedDatetimeEnd;

    @Override
    public String type() {
        return this.type;
    }

    public Object recursive() {
        return this.recursive;
    }

    public AzureDataLakeStoreReadSettings withRecursive(Object recursive) {
        this.recursive = recursive;
        return this;
    }

    public Object wildcardFolderPath() {
        return this.wildcardFolderPath;
    }

    public AzureDataLakeStoreReadSettings withWildcardFolderPath(Object wildcardFolderPath) {
        this.wildcardFolderPath = wildcardFolderPath;
        return this;
    }

    public Object wildcardFileName() {
        return this.wildcardFileName;
    }

    public AzureDataLakeStoreReadSettings withWildcardFileName(Object wildcardFileName) {
        this.wildcardFileName = wildcardFileName;
        return this;
    }

    public Object fileListPath() {
        return this.fileListPath;
    }

    public AzureDataLakeStoreReadSettings withFileListPath(Object fileListPath) {
        this.fileListPath = fileListPath;
        return this;
    }

    public Object listAfter() {
        return this.listAfter;
    }

    public AzureDataLakeStoreReadSettings withListAfter(Object listAfter) {
        this.listAfter = listAfter;
        return this;
    }

    public Object listBefore() {
        return this.listBefore;
    }

    public AzureDataLakeStoreReadSettings withListBefore(Object listBefore) {
        this.listBefore = listBefore;
        return this;
    }

    public Object enablePartitionDiscovery() {
        return this.enablePartitionDiscovery;
    }

    public AzureDataLakeStoreReadSettings withEnablePartitionDiscovery(Object enablePartitionDiscovery) {
        this.enablePartitionDiscovery = enablePartitionDiscovery;
        return this;
    }

    public Object partitionRootPath() {
        return this.partitionRootPath;
    }

    public AzureDataLakeStoreReadSettings withPartitionRootPath(Object partitionRootPath) {
        this.partitionRootPath = partitionRootPath;
        return this;
    }

    public Object deleteFilesAfterCompletion() {
        return this.deleteFilesAfterCompletion;
    }

    public AzureDataLakeStoreReadSettings withDeleteFilesAfterCompletion(Object deleteFilesAfterCompletion) {
        this.deleteFilesAfterCompletion = deleteFilesAfterCompletion;
        return this;
    }

    public Object modifiedDatetimeStart() {
        return this.modifiedDatetimeStart;
    }

    public AzureDataLakeStoreReadSettings withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        this.modifiedDatetimeStart = modifiedDatetimeStart;
        return this;
    }

    public Object modifiedDatetimeEnd() {
        return this.modifiedDatetimeEnd;
    }

    public AzureDataLakeStoreReadSettings withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        this.modifiedDatetimeEnd = modifiedDatetimeEnd;
        return this;
    }

    @Override
    public AzureDataLakeStoreReadSettings withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureDataLakeStoreReadSettings withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.recursive != null) {
            jsonWriter.writeUntypedField("recursive", this.recursive);
        }
        if (this.wildcardFolderPath != null) {
            jsonWriter.writeUntypedField("wildcardFolderPath", this.wildcardFolderPath);
        }
        if (this.wildcardFileName != null) {
            jsonWriter.writeUntypedField("wildcardFileName", this.wildcardFileName);
        }
        if (this.fileListPath != null) {
            jsonWriter.writeUntypedField("fileListPath", this.fileListPath);
        }
        if (this.listAfter != null) {
            jsonWriter.writeUntypedField("listAfter", this.listAfter);
        }
        if (this.listBefore != null) {
            jsonWriter.writeUntypedField("listBefore", this.listBefore);
        }
        if (this.enablePartitionDiscovery != null) {
            jsonWriter.writeUntypedField("enablePartitionDiscovery", this.enablePartitionDiscovery);
        }
        if (this.partitionRootPath != null) {
            jsonWriter.writeUntypedField("partitionRootPath", this.partitionRootPath);
        }
        if (this.deleteFilesAfterCompletion != null) {
            jsonWriter.writeUntypedField("deleteFilesAfterCompletion", this.deleteFilesAfterCompletion);
        }
        if (this.modifiedDatetimeStart != null) {
            jsonWriter.writeUntypedField("modifiedDatetimeStart", this.modifiedDatetimeStart);
        }
        if (this.modifiedDatetimeEnd != null) {
            jsonWriter.writeUntypedField("modifiedDatetimeEnd", this.modifiedDatetimeEnd);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDataLakeStoreReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDataLakeStoreReadSettings)jsonReader.readObject(reader -> {
            AzureDataLakeStoreReadSettings deserializedAzureDataLakeStoreReadSettings = new AzureDataLakeStoreReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.type = reader.getString();
                    continue;
                }
                if ("recursive".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.recursive = reader.readUntyped();
                    continue;
                }
                if ("wildcardFolderPath".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.wildcardFolderPath = reader.readUntyped();
                    continue;
                }
                if ("wildcardFileName".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.wildcardFileName = reader.readUntyped();
                    continue;
                }
                if ("fileListPath".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.fileListPath = reader.readUntyped();
                    continue;
                }
                if ("listAfter".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.listAfter = reader.readUntyped();
                    continue;
                }
                if ("listBefore".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.listBefore = reader.readUntyped();
                    continue;
                }
                if ("enablePartitionDiscovery".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.enablePartitionDiscovery = reader.readUntyped();
                    continue;
                }
                if ("partitionRootPath".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.partitionRootPath = reader.readUntyped();
                    continue;
                }
                if ("deleteFilesAfterCompletion".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.deleteFilesAfterCompletion = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeStart".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.modifiedDatetimeStart = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeEnd".equals(fieldName)) {
                    deserializedAzureDataLakeStoreReadSettings.modifiedDatetimeEnd = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDataLakeStoreReadSettings.withAdditionalProperties(additionalProperties);
            return deserializedAzureDataLakeStoreReadSettings;
        });
    }
}

