/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AmazonS3CompatibleLocation
extends DatasetLocation {
    private String type = "AmazonS3CompatibleLocation";
    private Object bucketName;
    private Object version;

    @Override
    public String type() {
        return this.type;
    }

    public Object bucketName() {
        return this.bucketName;
    }

    public AmazonS3CompatibleLocation withBucketName(Object bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public Object version() {
        return this.version;
    }

    public AmazonS3CompatibleLocation withVersion(Object version) {
        this.version = version;
        return this;
    }

    @Override
    public AmazonS3CompatibleLocation withFolderPath(Object folderPath) {
        super.withFolderPath(folderPath);
        return this;
    }

    @Override
    public AmazonS3CompatibleLocation withFileName(Object fileName) {
        super.withFileName(fileName);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.folderPath() != null) {
            jsonWriter.writeUntypedField("folderPath", this.folderPath());
        }
        if (this.fileName() != null) {
            jsonWriter.writeUntypedField("fileName", this.fileName());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.bucketName != null) {
            jsonWriter.writeUntypedField("bucketName", this.bucketName);
        }
        if (this.version != null) {
            jsonWriter.writeUntypedField("version", this.version);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonS3CompatibleLocation fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonS3CompatibleLocation)jsonReader.readObject(reader -> {
            AmazonS3CompatibleLocation deserializedAmazonS3CompatibleLocation = new AmazonS3CompatibleLocation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("folderPath".equals(fieldName)) {
                    deserializedAmazonS3CompatibleLocation.withFolderPath(reader.readUntyped());
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedAmazonS3CompatibleLocation.withFileName(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonS3CompatibleLocation.type = reader.getString();
                    continue;
                }
                if ("bucketName".equals(fieldName)) {
                    deserializedAmazonS3CompatibleLocation.bucketName = reader.readUntyped();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAmazonS3CompatibleLocation.version = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonS3CompatibleLocation.withAdditionalProperties(additionalProperties);
            return deserializedAmazonS3CompatibleLocation;
        });
    }
}

