/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ActivityPolicy
implements JsonSerializable<ActivityPolicy> {
    private Object timeout;
    private Object retry;
    private Integer retryIntervalInSeconds;
    private Boolean secureInput;
    private Boolean secureOutput;
    private Map<String, Object> additionalProperties;

    public Object timeout() {
        return this.timeout;
    }

    public ActivityPolicy withTimeout(Object timeout) {
        this.timeout = timeout;
        return this;
    }

    public Object retry() {
        return this.retry;
    }

    public ActivityPolicy withRetry(Object retry) {
        this.retry = retry;
        return this;
    }

    public Integer retryIntervalInSeconds() {
        return this.retryIntervalInSeconds;
    }

    public ActivityPolicy withRetryIntervalInSeconds(Integer retryIntervalInSeconds) {
        this.retryIntervalInSeconds = retryIntervalInSeconds;
        return this;
    }

    public Boolean secureInput() {
        return this.secureInput;
    }

    public ActivityPolicy withSecureInput(Boolean secureInput) {
        this.secureInput = secureInput;
        return this;
    }

    public Boolean secureOutput() {
        return this.secureOutput;
    }

    public ActivityPolicy withSecureOutput(Boolean secureOutput) {
        this.secureOutput = secureOutput;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public ActivityPolicy withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.timeout != null) {
            jsonWriter.writeUntypedField("timeout", this.timeout);
        }
        if (this.retry != null) {
            jsonWriter.writeUntypedField("retry", this.retry);
        }
        jsonWriter.writeNumberField("retryIntervalInSeconds", (Number)this.retryIntervalInSeconds);
        jsonWriter.writeBooleanField("secureInput", this.secureInput);
        jsonWriter.writeBooleanField("secureOutput", this.secureOutput);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ActivityPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ActivityPolicy)jsonReader.readObject(reader -> {
            ActivityPolicy deserializedActivityPolicy = new ActivityPolicy();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeout".equals(fieldName)) {
                    deserializedActivityPolicy.timeout = reader.readUntyped();
                    continue;
                }
                if ("retry".equals(fieldName)) {
                    deserializedActivityPolicy.retry = reader.readUntyped();
                    continue;
                }
                if ("retryIntervalInSeconds".equals(fieldName)) {
                    deserializedActivityPolicy.retryIntervalInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("secureInput".equals(fieldName)) {
                    deserializedActivityPolicy.secureInput = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("secureOutput".equals(fieldName)) {
                    deserializedActivityPolicy.secureOutput = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedActivityPolicy.additionalProperties = additionalProperties;
            return deserializedActivityPolicy;
        });
    }
}

