/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.ManagedPrivateEndpointsClient;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedPrivateEndpointResourceInner;
import com.azure.resourcemanager.datafactory.implementation.ManagedPrivateEndpointResourceImpl;
import com.azure.resourcemanager.datafactory.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datafactory.models.ManagedPrivateEndpointResource;
import com.azure.resourcemanager.datafactory.models.ManagedPrivateEndpoints;

public final class ManagedPrivateEndpointsImpl
implements ManagedPrivateEndpoints {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedPrivateEndpointsImpl.class);
    private final ManagedPrivateEndpointsClient innerClient;
    private final DataFactoryManager serviceManager;

    public ManagedPrivateEndpointsImpl(ManagedPrivateEndpointsClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ManagedPrivateEndpointResource> listByFactory(String resourceGroupName, String factoryName, String managedVirtualNetworkName) {
        PagedIterable<ManagedPrivateEndpointResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName, managedVirtualNetworkName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ManagedPrivateEndpointResourceImpl((ManagedPrivateEndpointResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ManagedPrivateEndpointResource> listByFactory(String resourceGroupName, String factoryName, String managedVirtualNetworkName, Context context) {
        PagedIterable<ManagedPrivateEndpointResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName, managedVirtualNetworkName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ManagedPrivateEndpointResourceImpl((ManagedPrivateEndpointResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ManagedPrivateEndpointResource> getWithResponse(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, String ifNoneMatch, Context context) {
        Response<ManagedPrivateEndpointResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, ifNoneMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ManagedPrivateEndpointResourceImpl((ManagedPrivateEndpointResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ManagedPrivateEndpointResource get(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName) {
        ManagedPrivateEndpointResourceInner inner = this.serviceClient().get(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName);
        if (inner != null) {
            return new ManagedPrivateEndpointResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, context);
    }

    @Override
    public void delete(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName) {
        this.serviceClient().delete(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName);
    }

    @Override
    public ManagedPrivateEndpointResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String managedVirtualNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "managedVirtualNetworks");
        if (managedVirtualNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedVirtualNetworks'.", id)));
        }
        String managedPrivateEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "managedPrivateEndpoints");
        if (managedPrivateEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedPrivateEndpoints'.", id)));
        }
        String localIfNoneMatch = null;
        return (ManagedPrivateEndpointResource)this.getWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, localIfNoneMatch, Context.NONE).getValue();
    }

    @Override
    public Response<ManagedPrivateEndpointResource> getByIdWithResponse(String id, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String managedVirtualNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "managedVirtualNetworks");
        if (managedVirtualNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedVirtualNetworks'.", id)));
        }
        String managedPrivateEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "managedPrivateEndpoints");
        if (managedPrivateEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedPrivateEndpoints'.", id)));
        }
        return this.getWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, ifNoneMatch, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String managedVirtualNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "managedVirtualNetworks");
        if (managedVirtualNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedVirtualNetworks'.", id)));
        }
        String managedPrivateEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "managedPrivateEndpoints");
        if (managedPrivateEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedPrivateEndpoints'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String managedVirtualNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "managedVirtualNetworks");
        if (managedVirtualNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedVirtualNetworks'.", id)));
        }
        String managedPrivateEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "managedPrivateEndpoints");
        if (managedPrivateEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedPrivateEndpoints'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, context);
    }

    private ManagedPrivateEndpointsClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedPrivateEndpointResourceImpl define(String name) {
        return new ManagedPrivateEndpointResourceImpl(name, this.manager());
    }
}

