/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.IntegrationRuntimesClient;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeAuthKeysInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeConnectionInfoInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeMonitoringDataInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeResourceInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeStatusResponseInner;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimeAuthKeysImpl;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimeConnectionInfoImpl;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimeMonitoringDataImpl;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseImpl;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimeResourceImpl;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimeStatusResponseImpl;
import com.azure.resourcemanager.datafactory.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datafactory.models.CreateLinkedIntegrationRuntimeRequest;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeAuthKeys;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeConnectionInfo;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeMonitoringData;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeRegenerateKeyParameters;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeResource;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeStatusResponse;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimes;
import com.azure.resourcemanager.datafactory.models.LinkedIntegrationRuntimeRequest;

public final class IntegrationRuntimesImpl
implements IntegrationRuntimes {
    private static final ClientLogger LOGGER = new ClientLogger(IntegrationRuntimesImpl.class);
    private final IntegrationRuntimesClient innerClient;
    private final DataFactoryManager serviceManager;

    public IntegrationRuntimesImpl(IntegrationRuntimesClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<IntegrationRuntimeResource> listByFactory(String resourceGroupName, String factoryName) {
        PagedIterable<IntegrationRuntimeResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IntegrationRuntimeResourceImpl((IntegrationRuntimeResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IntegrationRuntimeResource> listByFactory(String resourceGroupName, String factoryName, Context context) {
        PagedIterable<IntegrationRuntimeResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IntegrationRuntimeResourceImpl((IntegrationRuntimeResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<IntegrationRuntimeResource> getWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, String ifNoneMatch, Context context) {
        Response<IntegrationRuntimeResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, factoryName, integrationRuntimeName, ifNoneMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IntegrationRuntimeResourceImpl((IntegrationRuntimeResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public IntegrationRuntimeResource get(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        IntegrationRuntimeResourceInner inner = this.serviceClient().get(resourceGroupName, factoryName, integrationRuntimeName);
        if (inner != null) {
            return new IntegrationRuntimeResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, integrationRuntimeName, context);
    }

    @Override
    public void delete(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        this.serviceClient().delete(resourceGroupName, factoryName, integrationRuntimeName);
    }

    @Override
    public Response<IntegrationRuntimeStatusResponse> getStatusWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        Response<IntegrationRuntimeStatusResponseInner> inner = this.serviceClient().getStatusWithResponse(resourceGroupName, factoryName, integrationRuntimeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IntegrationRuntimeStatusResponseImpl((IntegrationRuntimeStatusResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IntegrationRuntimeStatusResponse getStatus(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        IntegrationRuntimeStatusResponseInner inner = this.serviceClient().getStatus(resourceGroupName, factoryName, integrationRuntimeName);
        if (inner != null) {
            return new IntegrationRuntimeStatusResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse> listOutboundNetworkDependenciesEndpointsWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        Response<IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner> inner = this.serviceClient().listOutboundNetworkDependenciesEndpointsWithResponse(resourceGroupName, factoryName, integrationRuntimeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseImpl((IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse listOutboundNetworkDependenciesEndpoints(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner inner = this.serviceClient().listOutboundNetworkDependenciesEndpoints(resourceGroupName, factoryName, integrationRuntimeName);
        if (inner != null) {
            return new IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<IntegrationRuntimeConnectionInfo> getConnectionInfoWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        Response<IntegrationRuntimeConnectionInfoInner> inner = this.serviceClient().getConnectionInfoWithResponse(resourceGroupName, factoryName, integrationRuntimeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IntegrationRuntimeConnectionInfoImpl((IntegrationRuntimeConnectionInfoInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IntegrationRuntimeConnectionInfo getConnectionInfo(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        IntegrationRuntimeConnectionInfoInner inner = this.serviceClient().getConnectionInfo(resourceGroupName, factoryName, integrationRuntimeName);
        if (inner != null) {
            return new IntegrationRuntimeConnectionInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<IntegrationRuntimeAuthKeys> regenerateAuthKeyWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, IntegrationRuntimeRegenerateKeyParameters regenerateKeyParameters, Context context) {
        Response<IntegrationRuntimeAuthKeysInner> inner = this.serviceClient().regenerateAuthKeyWithResponse(resourceGroupName, factoryName, integrationRuntimeName, regenerateKeyParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IntegrationRuntimeAuthKeysImpl((IntegrationRuntimeAuthKeysInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IntegrationRuntimeAuthKeys regenerateAuthKey(String resourceGroupName, String factoryName, String integrationRuntimeName, IntegrationRuntimeRegenerateKeyParameters regenerateKeyParameters) {
        IntegrationRuntimeAuthKeysInner inner = this.serviceClient().regenerateAuthKey(resourceGroupName, factoryName, integrationRuntimeName, regenerateKeyParameters);
        if (inner != null) {
            return new IntegrationRuntimeAuthKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<IntegrationRuntimeAuthKeys> listAuthKeysWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        Response<IntegrationRuntimeAuthKeysInner> inner = this.serviceClient().listAuthKeysWithResponse(resourceGroupName, factoryName, integrationRuntimeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IntegrationRuntimeAuthKeysImpl((IntegrationRuntimeAuthKeysInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IntegrationRuntimeAuthKeys listAuthKeys(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        IntegrationRuntimeAuthKeysInner inner = this.serviceClient().listAuthKeys(resourceGroupName, factoryName, integrationRuntimeName);
        if (inner != null) {
            return new IntegrationRuntimeAuthKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public IntegrationRuntimeStatusResponse start(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        IntegrationRuntimeStatusResponseInner inner = this.serviceClient().start(resourceGroupName, factoryName, integrationRuntimeName);
        if (inner != null) {
            return new IntegrationRuntimeStatusResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public IntegrationRuntimeStatusResponse start(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        IntegrationRuntimeStatusResponseInner inner = this.serviceClient().start(resourceGroupName, factoryName, integrationRuntimeName, context);
        if (inner != null) {
            return new IntegrationRuntimeStatusResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void stop(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        this.serviceClient().stop(resourceGroupName, factoryName, integrationRuntimeName);
    }

    @Override
    public void stop(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        this.serviceClient().stop(resourceGroupName, factoryName, integrationRuntimeName, context);
    }

    @Override
    public Response<Void> syncCredentialsWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return this.serviceClient().syncCredentialsWithResponse(resourceGroupName, factoryName, integrationRuntimeName, context);
    }

    @Override
    public void syncCredentials(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        this.serviceClient().syncCredentials(resourceGroupName, factoryName, integrationRuntimeName);
    }

    @Override
    public Response<IntegrationRuntimeMonitoringData> getMonitoringDataWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        Response<IntegrationRuntimeMonitoringDataInner> inner = this.serviceClient().getMonitoringDataWithResponse(resourceGroupName, factoryName, integrationRuntimeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IntegrationRuntimeMonitoringDataImpl((IntegrationRuntimeMonitoringDataInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IntegrationRuntimeMonitoringData getMonitoringData(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        IntegrationRuntimeMonitoringDataInner inner = this.serviceClient().getMonitoringData(resourceGroupName, factoryName, integrationRuntimeName);
        if (inner != null) {
            return new IntegrationRuntimeMonitoringDataImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> upgradeWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return this.serviceClient().upgradeWithResponse(resourceGroupName, factoryName, integrationRuntimeName, context);
    }

    @Override
    public void upgrade(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        this.serviceClient().upgrade(resourceGroupName, factoryName, integrationRuntimeName);
    }

    @Override
    public Response<Void> removeLinksWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, LinkedIntegrationRuntimeRequest linkedIntegrationRuntimeRequest, Context context) {
        return this.serviceClient().removeLinksWithResponse(resourceGroupName, factoryName, integrationRuntimeName, linkedIntegrationRuntimeRequest, context);
    }

    @Override
    public void removeLinks(String resourceGroupName, String factoryName, String integrationRuntimeName, LinkedIntegrationRuntimeRequest linkedIntegrationRuntimeRequest) {
        this.serviceClient().removeLinks(resourceGroupName, factoryName, integrationRuntimeName, linkedIntegrationRuntimeRequest);
    }

    @Override
    public Response<IntegrationRuntimeStatusResponse> createLinkedIntegrationRuntimeWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, CreateLinkedIntegrationRuntimeRequest createLinkedIntegrationRuntimeRequest, Context context) {
        Response<IntegrationRuntimeStatusResponseInner> inner = this.serviceClient().createLinkedIntegrationRuntimeWithResponse(resourceGroupName, factoryName, integrationRuntimeName, createLinkedIntegrationRuntimeRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IntegrationRuntimeStatusResponseImpl((IntegrationRuntimeStatusResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IntegrationRuntimeStatusResponse createLinkedIntegrationRuntime(String resourceGroupName, String factoryName, String integrationRuntimeName, CreateLinkedIntegrationRuntimeRequest createLinkedIntegrationRuntimeRequest) {
        IntegrationRuntimeStatusResponseInner inner = this.serviceClient().createLinkedIntegrationRuntime(resourceGroupName, factoryName, integrationRuntimeName, createLinkedIntegrationRuntimeRequest);
        if (inner != null) {
            return new IntegrationRuntimeStatusResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public IntegrationRuntimeResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String integrationRuntimeName = ResourceManagerUtils.getValueFromIdByName(id, "integrationRuntimes");
        if (integrationRuntimeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'integrationRuntimes'.", id)));
        }
        String localIfNoneMatch = null;
        return (IntegrationRuntimeResource)this.getWithResponse(resourceGroupName, factoryName, integrationRuntimeName, localIfNoneMatch, Context.NONE).getValue();
    }

    @Override
    public Response<IntegrationRuntimeResource> getByIdWithResponse(String id, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String integrationRuntimeName = ResourceManagerUtils.getValueFromIdByName(id, "integrationRuntimes");
        if (integrationRuntimeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'integrationRuntimes'.", id)));
        }
        return this.getWithResponse(resourceGroupName, factoryName, integrationRuntimeName, ifNoneMatch, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String integrationRuntimeName = ResourceManagerUtils.getValueFromIdByName(id, "integrationRuntimes");
        if (integrationRuntimeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'integrationRuntimes'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, factoryName, integrationRuntimeName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String integrationRuntimeName = ResourceManagerUtils.getValueFromIdByName(id, "integrationRuntimes");
        if (integrationRuntimeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'integrationRuntimes'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, factoryName, integrationRuntimeName, context);
    }

    private IntegrationRuntimesClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public IntegrationRuntimeResourceImpl define(String name) {
        return new IntegrationRuntimeResourceImpl(name, this.manager());
    }
}

