/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.GlobalParameterResourceInner;
import com.azure.resourcemanager.datafactory.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datafactory.models.GlobalParameterResource;
import com.azure.resourcemanager.datafactory.models.GlobalParameterSpecification;
import java.util.Collections;
import java.util.Map;

public final class GlobalParameterResourceImpl
implements GlobalParameterResource,
GlobalParameterResource.Definition,
GlobalParameterResource.Update {
    private GlobalParameterResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String globalParameterName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public Map<String, GlobalParameterSpecification> properties() {
        Map<String, GlobalParameterSpecification> inner = this.innerModel().properties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public GlobalParameterResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public GlobalParameterResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    @Override
    public GlobalParameterResource create() {
        this.innerObject = (GlobalParameterResourceInner)((Object)this.serviceManager.serviceClient().getGlobalParameters().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.globalParameterName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public GlobalParameterResource create(Context context) {
        this.innerObject = (GlobalParameterResourceInner)((Object)this.serviceManager.serviceClient().getGlobalParameters().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.globalParameterName, this.innerModel(), context).getValue());
        return this;
    }

    GlobalParameterResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new GlobalParameterResourceInner();
        this.serviceManager = serviceManager;
        this.globalParameterName = name;
    }

    @Override
    public GlobalParameterResourceImpl update() {
        return this;
    }

    @Override
    public GlobalParameterResource apply() {
        this.innerObject = (GlobalParameterResourceInner)((Object)this.serviceManager.serviceClient().getGlobalParameters().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.globalParameterName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public GlobalParameterResource apply(Context context) {
        this.innerObject = (GlobalParameterResourceInner)((Object)this.serviceManager.serviceClient().getGlobalParameters().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.globalParameterName, this.innerModel(), context).getValue());
        return this;
    }

    GlobalParameterResourceImpl(GlobalParameterResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.globalParameterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "globalParameters");
    }

    @Override
    public GlobalParameterResource refresh() {
        this.innerObject = (GlobalParameterResourceInner)((Object)this.serviceManager.serviceClient().getGlobalParameters().getWithResponse(this.resourceGroupName, this.factoryName, this.globalParameterName, Context.NONE).getValue());
        return this;
    }

    @Override
    public GlobalParameterResource refresh(Context context) {
        this.innerObject = (GlobalParameterResourceInner)((Object)this.serviceManager.serviceClient().getGlobalParameters().getWithResponse(this.resourceGroupName, this.factoryName, this.globalParameterName, context).getValue());
        return this;
    }

    @Override
    public GlobalParameterResourceImpl withProperties(Map<String, GlobalParameterSpecification> properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

