/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.Expression;
import java.io.IOException;
import java.util.List;

public final class UntilActivityTypeProperties
implements JsonSerializable<UntilActivityTypeProperties> {
    private Expression expression;
    private Object timeout;
    private List<Activity> activities;
    private static final ClientLogger LOGGER = new ClientLogger(UntilActivityTypeProperties.class);

    public Expression expression() {
        return this.expression;
    }

    public UntilActivityTypeProperties withExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public Object timeout() {
        return this.timeout;
    }

    public UntilActivityTypeProperties withTimeout(Object timeout) {
        this.timeout = timeout;
        return this;
    }

    public List<Activity> activities() {
        return this.activities;
    }

    public UntilActivityTypeProperties withActivities(List<Activity> activities) {
        this.activities = activities;
        return this;
    }

    public void validate() {
        if (this.expression() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property expression in model UntilActivityTypeProperties"));
        }
        this.expression().validate();
        if (this.activities() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property activities in model UntilActivityTypeProperties"));
        }
        this.activities().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("expression", (JsonSerializable)this.expression);
        jsonWriter.writeArrayField("activities", this.activities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.timeout != null) {
            jsonWriter.writeUntypedField("timeout", this.timeout);
        }
        return jsonWriter.writeEndObject();
    }

    public static UntilActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (UntilActivityTypeProperties)jsonReader.readObject(reader -> {
            UntilActivityTypeProperties deserializedUntilActivityTypeProperties = new UntilActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expression".equals(fieldName)) {
                    deserializedUntilActivityTypeProperties.expression = Expression.fromJson(reader);
                    continue;
                }
                if ("activities".equals(fieldName)) {
                    List activities;
                    deserializedUntilActivityTypeProperties.activities = activities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedUntilActivityTypeProperties.timeout = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUntilActivityTypeProperties;
        });
    }
}

