/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.Pipeline;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PipelineFolder;
import com.azure.resourcemanager.datafactory.models.PipelinePolicy;
import com.azure.resourcemanager.datafactory.models.VariableSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class PipelineResourceInner
extends SubResource {
    private Pipeline innerProperties = new Pipeline();
    private String name;
    private String type;
    private String etag;
    private Map<String, Object> additionalProperties;
    private static final ClientLogger LOGGER = new ClientLogger(PipelineResourceInner.class);

    private Pipeline innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public PipelineResourceInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public PipelineResourceInner withId(String id) {
        super.withId(id);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public PipelineResourceInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Pipeline();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public List<Activity> activities() {
        return this.innerProperties() == null ? null : this.innerProperties().activities();
    }

    public PipelineResourceInner withActivities(List<Activity> activities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Pipeline();
        }
        this.innerProperties().withActivities(activities);
        return this;
    }

    public Map<String, ParameterSpecification> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public PipelineResourceInner withParameters(Map<String, ParameterSpecification> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Pipeline();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public Map<String, VariableSpecification> variables() {
        return this.innerProperties() == null ? null : this.innerProperties().variables();
    }

    public PipelineResourceInner withVariables(Map<String, VariableSpecification> variables) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Pipeline();
        }
        this.innerProperties().withVariables(variables);
        return this;
    }

    public Integer concurrency() {
        return this.innerProperties() == null ? null : this.innerProperties().concurrency();
    }

    public PipelineResourceInner withConcurrency(Integer concurrency) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Pipeline();
        }
        this.innerProperties().withConcurrency(concurrency);
        return this;
    }

    public List<Object> annotations() {
        return this.innerProperties() == null ? null : this.innerProperties().annotations();
    }

    public PipelineResourceInner withAnnotations(List<Object> annotations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Pipeline();
        }
        this.innerProperties().withAnnotations(annotations);
        return this;
    }

    public Map<String, Object> runDimensions() {
        return this.innerProperties() == null ? null : this.innerProperties().runDimensions();
    }

    public PipelineResourceInner withRunDimensions(Map<String, Object> runDimensions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Pipeline();
        }
        this.innerProperties().withRunDimensions(runDimensions);
        return this;
    }

    public PipelineFolder folder() {
        return this.innerProperties() == null ? null : this.innerProperties().folder();
    }

    public PipelineResourceInner withFolder(PipelineFolder folder) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Pipeline();
        }
        this.innerProperties().withFolder(folder);
        return this;
    }

    public PipelinePolicy policy() {
        return this.innerProperties() == null ? null : this.innerProperties().policy();
    }

    public PipelineResourceInner withPolicy(PipelinePolicy policy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Pipeline();
        }
        this.innerProperties().withPolicy(policy);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model PipelineResourceInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PipelineResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (PipelineResourceInner)((Object)jsonReader.readObject(reader -> {
            PipelineResourceInner deserializedPipelineResourceInner = new PipelineResourceInner();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPipelineResourceInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPipelineResourceInner.innerProperties = Pipeline.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPipelineResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPipelineResourceInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedPipelineResourceInner.etag = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedPipelineResourceInner.additionalProperties = additionalProperties;
            return deserializedPipelineResourceInner;
        }));
    }
}

