/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import java.io.IOException;

public final class LookupActivityTypeProperties
implements JsonSerializable<LookupActivityTypeProperties> {
    private CopySource source;
    private DatasetReference dataset;
    private Object firstRowOnly;
    private static final ClientLogger LOGGER = new ClientLogger(LookupActivityTypeProperties.class);

    public CopySource source() {
        return this.source;
    }

    public LookupActivityTypeProperties withSource(CopySource source) {
        this.source = source;
        return this;
    }

    public DatasetReference dataset() {
        return this.dataset;
    }

    public LookupActivityTypeProperties withDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    public Object firstRowOnly() {
        return this.firstRowOnly;
    }

    public LookupActivityTypeProperties withFirstRowOnly(Object firstRowOnly) {
        this.firstRowOnly = firstRowOnly;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property source in model LookupActivityTypeProperties"));
        }
        this.source().validate();
        if (this.dataset() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataset in model LookupActivityTypeProperties"));
        }
        this.dataset().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset);
        if (this.firstRowOnly != null) {
            jsonWriter.writeUntypedField("firstRowOnly", this.firstRowOnly);
        }
        return jsonWriter.writeEndObject();
    }

    public static LookupActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LookupActivityTypeProperties)jsonReader.readObject(reader -> {
            LookupActivityTypeProperties deserializedLookupActivityTypeProperties = new LookupActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedLookupActivityTypeProperties.source = CopySource.fromJson(reader);
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    deserializedLookupActivityTypeProperties.dataset = DatasetReference.fromJson(reader);
                    continue;
                }
                if ("firstRowOnly".equals(fieldName)) {
                    deserializedLookupActivityTypeProperties.firstRowOnly = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLookupActivityTypeProperties;
        });
    }
}

