/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.Expression;
import java.io.IOException;
import java.util.List;

public final class IfConditionActivityTypeProperties
implements JsonSerializable<IfConditionActivityTypeProperties> {
    private Expression expression;
    private List<Activity> ifTrueActivities;
    private List<Activity> ifFalseActivities;
    private static final ClientLogger LOGGER = new ClientLogger(IfConditionActivityTypeProperties.class);

    public Expression expression() {
        return this.expression;
    }

    public IfConditionActivityTypeProperties withExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public List<Activity> ifTrueActivities() {
        return this.ifTrueActivities;
    }

    public IfConditionActivityTypeProperties withIfTrueActivities(List<Activity> ifTrueActivities) {
        this.ifTrueActivities = ifTrueActivities;
        return this;
    }

    public List<Activity> ifFalseActivities() {
        return this.ifFalseActivities;
    }

    public IfConditionActivityTypeProperties withIfFalseActivities(List<Activity> ifFalseActivities) {
        this.ifFalseActivities = ifFalseActivities;
        return this;
    }

    public void validate() {
        if (this.expression() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property expression in model IfConditionActivityTypeProperties"));
        }
        this.expression().validate();
        if (this.ifTrueActivities() != null) {
            this.ifTrueActivities().forEach(e -> e.validate());
        }
        if (this.ifFalseActivities() != null) {
            this.ifFalseActivities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("expression", (JsonSerializable)this.expression);
        jsonWriter.writeArrayField("ifTrueActivities", this.ifTrueActivities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("ifFalseActivities", this.ifFalseActivities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static IfConditionActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IfConditionActivityTypeProperties)jsonReader.readObject(reader -> {
            IfConditionActivityTypeProperties deserializedIfConditionActivityTypeProperties = new IfConditionActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expression".equals(fieldName)) {
                    deserializedIfConditionActivityTypeProperties.expression = Expression.fromJson(reader);
                    continue;
                }
                if ("ifTrueActivities".equals(fieldName)) {
                    List ifTrueActivities;
                    deserializedIfConditionActivityTypeProperties.ifTrueActivities = ifTrueActivities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                    continue;
                }
                if ("ifFalseActivities".equals(fieldName)) {
                    List ifFalseActivities;
                    deserializedIfConditionActivityTypeProperties.ifFalseActivities = ifFalseActivities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIfConditionActivityTypeProperties;
        });
    }
}

