/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetStorageFormat;
import java.io.IOException;

public final class HttpDatasetTypeProperties
implements JsonSerializable<HttpDatasetTypeProperties> {
    private Object relativeUrl;
    private Object requestMethod;
    private Object requestBody;
    private Object additionalHeaders;
    private DatasetStorageFormat format;
    private DatasetCompression compression;

    public Object relativeUrl() {
        return this.relativeUrl;
    }

    public HttpDatasetTypeProperties withRelativeUrl(Object relativeUrl) {
        this.relativeUrl = relativeUrl;
        return this;
    }

    public Object requestMethod() {
        return this.requestMethod;
    }

    public HttpDatasetTypeProperties withRequestMethod(Object requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public Object requestBody() {
        return this.requestBody;
    }

    public HttpDatasetTypeProperties withRequestBody(Object requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public Object additionalHeaders() {
        return this.additionalHeaders;
    }

    public HttpDatasetTypeProperties withAdditionalHeaders(Object additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
        return this;
    }

    public DatasetStorageFormat format() {
        return this.format;
    }

    public HttpDatasetTypeProperties withFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    public DatasetCompression compression() {
        return this.compression;
    }

    public HttpDatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    public void validate() {
        if (this.format() != null) {
            this.format().validate();
        }
        if (this.compression() != null) {
            this.compression().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.relativeUrl != null) {
            jsonWriter.writeUntypedField("relativeUrl", this.relativeUrl);
        }
        if (this.requestMethod != null) {
            jsonWriter.writeUntypedField("requestMethod", this.requestMethod);
        }
        if (this.requestBody != null) {
            jsonWriter.writeUntypedField("requestBody", this.requestBody);
        }
        if (this.additionalHeaders != null) {
            jsonWriter.writeUntypedField("additionalHeaders", this.additionalHeaders);
        }
        jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
        jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
        return jsonWriter.writeEndObject();
    }

    public static HttpDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HttpDatasetTypeProperties)jsonReader.readObject(reader -> {
            HttpDatasetTypeProperties deserializedHttpDatasetTypeProperties = new HttpDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("relativeUrl".equals(fieldName)) {
                    deserializedHttpDatasetTypeProperties.relativeUrl = reader.readUntyped();
                    continue;
                }
                if ("requestMethod".equals(fieldName)) {
                    deserializedHttpDatasetTypeProperties.requestMethod = reader.readUntyped();
                    continue;
                }
                if ("requestBody".equals(fieldName)) {
                    deserializedHttpDatasetTypeProperties.requestBody = reader.readUntyped();
                    continue;
                }
                if ("additionalHeaders".equals(fieldName)) {
                    deserializedHttpDatasetTypeProperties.additionalHeaders = reader.readUntyped();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedHttpDatasetTypeProperties.format = DatasetStorageFormat.fromJson(reader);
                    continue;
                }
                if ("compression".equals(fieldName)) {
                    deserializedHttpDatasetTypeProperties.compression = DatasetCompression.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpDatasetTypeProperties;
        });
    }
}

