/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.GreenplumAuthenticationType;
import java.io.IOException;

public final class GreenplumLinkedServiceTypeProperties
implements JsonSerializable<GreenplumLinkedServiceTypeProperties> {
    private Object connectionString;
    private AzureKeyVaultSecretReference pwd;
    private String encryptedCredential;
    private GreenplumAuthenticationType authenticationType;
    private Object host;
    private Object port;
    private Object username;
    private Object database;
    private Object sslMode;
    private Object connectionTimeout;
    private Object commandTimeout;

    public Object connectionString() {
        return this.connectionString;
    }

    public GreenplumLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureKeyVaultSecretReference pwd() {
        return this.pwd;
    }

    public GreenplumLinkedServiceTypeProperties withPwd(AzureKeyVaultSecretReference pwd) {
        this.pwd = pwd;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public GreenplumLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public GreenplumAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public GreenplumLinkedServiceTypeProperties withAuthenticationType(GreenplumAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object host() {
        return this.host;
    }

    public GreenplumLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public GreenplumLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public GreenplumLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public Object database() {
        return this.database;
    }

    public GreenplumLinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object sslMode() {
        return this.sslMode;
    }

    public GreenplumLinkedServiceTypeProperties withSslMode(Object sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public Object connectionTimeout() {
        return this.connectionTimeout;
    }

    public GreenplumLinkedServiceTypeProperties withConnectionTimeout(Object connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Object commandTimeout() {
        return this.commandTimeout;
    }

    public GreenplumLinkedServiceTypeProperties withCommandTimeout(Object commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public void validate() {
        if (this.pwd() != null) {
            this.pwd().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.connectionString != null) {
            jsonWriter.writeUntypedField("connectionString", this.connectionString);
        }
        jsonWriter.writeJsonField("pwd", (JsonSerializable)this.pwd);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.host != null) {
            jsonWriter.writeUntypedField("host", this.host);
        }
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        if (this.database != null) {
            jsonWriter.writeUntypedField("database", this.database);
        }
        if (this.sslMode != null) {
            jsonWriter.writeUntypedField("sslMode", this.sslMode);
        }
        if (this.connectionTimeout != null) {
            jsonWriter.writeUntypedField("connectionTimeout", this.connectionTimeout);
        }
        if (this.commandTimeout != null) {
            jsonWriter.writeUntypedField("commandTimeout", this.commandTimeout);
        }
        return jsonWriter.writeEndObject();
    }

    public static GreenplumLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GreenplumLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            GreenplumLinkedServiceTypeProperties deserializedGreenplumLinkedServiceTypeProperties = new GreenplumLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedGreenplumLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("pwd".equals(fieldName)) {
                    deserializedGreenplumLinkedServiceTypeProperties.pwd = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedGreenplumLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedGreenplumLinkedServiceTypeProperties.authenticationType = GreenplumAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("host".equals(fieldName)) {
                    deserializedGreenplumLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedGreenplumLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedGreenplumLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedGreenplumLinkedServiceTypeProperties.database = reader.readUntyped();
                    continue;
                }
                if ("sslMode".equals(fieldName)) {
                    deserializedGreenplumLinkedServiceTypeProperties.sslMode = reader.readUntyped();
                    continue;
                }
                if ("connectionTimeout".equals(fieldName)) {
                    deserializedGreenplumLinkedServiceTypeProperties.connectionTimeout = reader.readUntyped();
                    continue;
                }
                if ("commandTimeout".equals(fieldName)) {
                    deserializedGreenplumLinkedServiceTypeProperties.commandTimeout = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGreenplumLinkedServiceTypeProperties;
        });
    }
}

