/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.GoogleAdWordsAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class GoogleAdWordsLinkedServiceTypeProperties
implements JsonSerializable<GoogleAdWordsLinkedServiceTypeProperties> {
    private Object connectionProperties;
    private Object clientCustomerId;
    private SecretBase developerToken;
    private GoogleAdWordsAuthenticationType authenticationType;
    private SecretBase refreshToken;
    private Object clientId;
    private SecretBase clientSecret;
    private Object email;
    private Object keyFilePath;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private SecretBase privateKey;
    private Object loginCustomerId;
    private Object googleAdsApiVersion;
    private Object supportLegacyDataTypes;
    private String encryptedCredential;

    public Object connectionProperties() {
        return this.connectionProperties;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withConnectionProperties(Object connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    public Object clientCustomerId() {
        return this.clientCustomerId;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withClientCustomerId(Object clientCustomerId) {
        this.clientCustomerId = clientCustomerId;
        return this;
    }

    public SecretBase developerToken() {
        return this.developerToken;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withDeveloperToken(SecretBase developerToken) {
        this.developerToken = developerToken;
        return this;
    }

    public GoogleAdWordsAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withAuthenticationType(GoogleAdWordsAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public SecretBase refreshToken() {
        return this.refreshToken;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withRefreshToken(SecretBase refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object email() {
        return this.email;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withEmail(Object email) {
        this.email = email;
        return this;
    }

    public Object keyFilePath() {
        return this.keyFilePath;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withKeyFilePath(Object keyFilePath) {
        this.keyFilePath = keyFilePath;
        return this;
    }

    public Object trustedCertPath() {
        return this.trustedCertPath;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public SecretBase privateKey() {
        return this.privateKey;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withPrivateKey(SecretBase privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public Object loginCustomerId() {
        return this.loginCustomerId;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withLoginCustomerId(Object loginCustomerId) {
        this.loginCustomerId = loginCustomerId;
        return this;
    }

    public Object googleAdsApiVersion() {
        return this.googleAdsApiVersion;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withGoogleAdsApiVersion(Object googleAdsApiVersion) {
        this.googleAdsApiVersion = googleAdsApiVersion;
        return this;
    }

    public Object supportLegacyDataTypes() {
        return this.supportLegacyDataTypes;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withSupportLegacyDataTypes(Object supportLegacyDataTypes) {
        this.supportLegacyDataTypes = supportLegacyDataTypes;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public GoogleAdWordsLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.developerToken() != null) {
            this.developerToken().validate();
        }
        if (this.refreshToken() != null) {
            this.refreshToken().validate();
        }
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
        if (this.privateKey() != null) {
            this.privateKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.connectionProperties != null) {
            jsonWriter.writeUntypedField("connectionProperties", this.connectionProperties);
        }
        if (this.clientCustomerId != null) {
            jsonWriter.writeUntypedField("clientCustomerID", this.clientCustomerId);
        }
        jsonWriter.writeJsonField("developerToken", (JsonSerializable)this.developerToken);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeJsonField("refreshToken", (JsonSerializable)this.refreshToken);
        if (this.clientId != null) {
            jsonWriter.writeUntypedField("clientId", this.clientId);
        }
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        if (this.email != null) {
            jsonWriter.writeUntypedField("email", this.email);
        }
        if (this.keyFilePath != null) {
            jsonWriter.writeUntypedField("keyFilePath", this.keyFilePath);
        }
        if (this.trustedCertPath != null) {
            jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
        }
        if (this.useSystemTrustStore != null) {
            jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
        }
        jsonWriter.writeJsonField("privateKey", (JsonSerializable)this.privateKey);
        if (this.loginCustomerId != null) {
            jsonWriter.writeUntypedField("loginCustomerID", this.loginCustomerId);
        }
        if (this.googleAdsApiVersion != null) {
            jsonWriter.writeUntypedField("googleAdsApiVersion", this.googleAdsApiVersion);
        }
        if (this.supportLegacyDataTypes != null) {
            jsonWriter.writeUntypedField("supportLegacyDataTypes", this.supportLegacyDataTypes);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static GoogleAdWordsLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GoogleAdWordsLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            GoogleAdWordsLinkedServiceTypeProperties deserializedGoogleAdWordsLinkedServiceTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionProperties".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.connectionProperties = reader.readUntyped();
                    continue;
                }
                if ("clientCustomerID".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.clientCustomerId = reader.readUntyped();
                    continue;
                }
                if ("developerToken".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.developerToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.authenticationType = GoogleAdWordsAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("refreshToken".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.refreshToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.clientSecret = SecretBase.fromJson(reader);
                    continue;
                }
                if ("email".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.email = reader.readUntyped();
                    continue;
                }
                if ("keyFilePath".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.keyFilePath = reader.readUntyped();
                    continue;
                }
                if ("trustedCertPath".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.trustedCertPath = reader.readUntyped();
                    continue;
                }
                if ("useSystemTrustStore".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.useSystemTrustStore = reader.readUntyped();
                    continue;
                }
                if ("privateKey".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.privateKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("loginCustomerID".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.loginCustomerId = reader.readUntyped();
                    continue;
                }
                if ("googleAdsApiVersion".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.googleAdsApiVersion = reader.readUntyped();
                    continue;
                }
                if ("supportLegacyDataTypes".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.supportLegacyDataTypes = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGoogleAdWordsLinkedServiceTypeProperties;
        });
    }
}

