/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.EncryptionConfiguration;
import com.azure.resourcemanager.datafactory.models.FactoryRepoConfiguration;
import com.azure.resourcemanager.datafactory.models.GlobalParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PublicNetworkAccess;
import com.azure.resourcemanager.datafactory.models.PurviewConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class FactoryProperties
implements JsonSerializable<FactoryProperties> {
    private String provisioningState;
    private OffsetDateTime createTime;
    private String version;
    private PurviewConfiguration purviewConfiguration;
    private FactoryRepoConfiguration repoConfiguration;
    private Map<String, GlobalParameterSpecification> globalParameters;
    private EncryptionConfiguration encryption;
    private PublicNetworkAccess publicNetworkAccess;

    public String provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime createTime() {
        return this.createTime;
    }

    public String version() {
        return this.version;
    }

    public PurviewConfiguration purviewConfiguration() {
        return this.purviewConfiguration;
    }

    public FactoryProperties withPurviewConfiguration(PurviewConfiguration purviewConfiguration) {
        this.purviewConfiguration = purviewConfiguration;
        return this;
    }

    public FactoryRepoConfiguration repoConfiguration() {
        return this.repoConfiguration;
    }

    public FactoryProperties withRepoConfiguration(FactoryRepoConfiguration repoConfiguration) {
        this.repoConfiguration = repoConfiguration;
        return this;
    }

    public Map<String, GlobalParameterSpecification> globalParameters() {
        return this.globalParameters;
    }

    public FactoryProperties withGlobalParameters(Map<String, GlobalParameterSpecification> globalParameters) {
        this.globalParameters = globalParameters;
        return this;
    }

    public EncryptionConfiguration encryption() {
        return this.encryption;
    }

    public FactoryProperties withEncryption(EncryptionConfiguration encryption) {
        this.encryption = encryption;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public FactoryProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public void validate() {
        if (this.purviewConfiguration() != null) {
            this.purviewConfiguration().validate();
        }
        if (this.repoConfiguration() != null) {
            this.repoConfiguration().validate();
        }
        if (this.globalParameters() != null) {
            this.globalParameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("purviewConfiguration", (JsonSerializable)this.purviewConfiguration);
        jsonWriter.writeJsonField("repoConfiguration", (JsonSerializable)this.repoConfiguration);
        jsonWriter.writeMapField("globalParameters", this.globalParameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        return jsonWriter.writeEndObject();
    }

    public static FactoryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FactoryProperties)jsonReader.readObject(reader -> {
            FactoryProperties deserializedFactoryProperties = new FactoryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedFactoryProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedFactoryProperties.createTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedFactoryProperties.version = reader.getString();
                    continue;
                }
                if ("purviewConfiguration".equals(fieldName)) {
                    deserializedFactoryProperties.purviewConfiguration = PurviewConfiguration.fromJson(reader);
                    continue;
                }
                if ("repoConfiguration".equals(fieldName)) {
                    deserializedFactoryProperties.repoConfiguration = FactoryRepoConfiguration.fromJson(reader);
                    continue;
                }
                if ("globalParameters".equals(fieldName)) {
                    Map globalParameters;
                    deserializedFactoryProperties.globalParameters = globalParameters = reader.readMap(reader1 -> GlobalParameterSpecification.fromJson(reader1));
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedFactoryProperties.encryption = EncryptionConfiguration.fromJson(reader);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedFactoryProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFactoryProperties;
        });
    }
}

