/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;

public final class ExcelDatasetTypeProperties
implements JsonSerializable<ExcelDatasetTypeProperties> {
    private DatasetLocation location;
    private Object sheetName;
    private Object sheetIndex;
    private Object range;
    private Object firstRowAsHeader;
    private DatasetCompression compression;
    private Object nullValue;
    private static final ClientLogger LOGGER = new ClientLogger(ExcelDatasetTypeProperties.class);

    public DatasetLocation location() {
        return this.location;
    }

    public ExcelDatasetTypeProperties withLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    public Object sheetName() {
        return this.sheetName;
    }

    public ExcelDatasetTypeProperties withSheetName(Object sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public Object sheetIndex() {
        return this.sheetIndex;
    }

    public ExcelDatasetTypeProperties withSheetIndex(Object sheetIndex) {
        this.sheetIndex = sheetIndex;
        return this;
    }

    public Object range() {
        return this.range;
    }

    public ExcelDatasetTypeProperties withRange(Object range) {
        this.range = range;
        return this;
    }

    public Object firstRowAsHeader() {
        return this.firstRowAsHeader;
    }

    public ExcelDatasetTypeProperties withFirstRowAsHeader(Object firstRowAsHeader) {
        this.firstRowAsHeader = firstRowAsHeader;
        return this;
    }

    public DatasetCompression compression() {
        return this.compression;
    }

    public ExcelDatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    public Object nullValue() {
        return this.nullValue;
    }

    public ExcelDatasetTypeProperties withNullValue(Object nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model ExcelDatasetTypeProperties"));
        }
        this.location().validate();
        if (this.compression() != null) {
            this.compression().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
        if (this.sheetName != null) {
            jsonWriter.writeUntypedField("sheetName", this.sheetName);
        }
        if (this.sheetIndex != null) {
            jsonWriter.writeUntypedField("sheetIndex", this.sheetIndex);
        }
        if (this.range != null) {
            jsonWriter.writeUntypedField("range", this.range);
        }
        if (this.firstRowAsHeader != null) {
            jsonWriter.writeUntypedField("firstRowAsHeader", this.firstRowAsHeader);
        }
        jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
        if (this.nullValue != null) {
            jsonWriter.writeUntypedField("nullValue", this.nullValue);
        }
        return jsonWriter.writeEndObject();
    }

    public static ExcelDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExcelDatasetTypeProperties)jsonReader.readObject(reader -> {
            ExcelDatasetTypeProperties deserializedExcelDatasetTypeProperties = new ExcelDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedExcelDatasetTypeProperties.location = DatasetLocation.fromJson(reader);
                    continue;
                }
                if ("sheetName".equals(fieldName)) {
                    deserializedExcelDatasetTypeProperties.sheetName = reader.readUntyped();
                    continue;
                }
                if ("sheetIndex".equals(fieldName)) {
                    deserializedExcelDatasetTypeProperties.sheetIndex = reader.readUntyped();
                    continue;
                }
                if ("range".equals(fieldName)) {
                    deserializedExcelDatasetTypeProperties.range = reader.readUntyped();
                    continue;
                }
                if ("firstRowAsHeader".equals(fieldName)) {
                    deserializedExcelDatasetTypeProperties.firstRowAsHeader = reader.readUntyped();
                    continue;
                }
                if ("compression".equals(fieldName)) {
                    deserializedExcelDatasetTypeProperties.compression = DatasetCompression.fromJson(reader);
                    continue;
                }
                if ("nullValue".equals(fieldName)) {
                    deserializedExcelDatasetTypeProperties.nullValue = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExcelDatasetTypeProperties;
        });
    }
}

