/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;

public final class BinaryDatasetTypeProperties
implements JsonSerializable<BinaryDatasetTypeProperties> {
    private DatasetLocation location;
    private DatasetCompression compression;
    private static final ClientLogger LOGGER = new ClientLogger(BinaryDatasetTypeProperties.class);

    public DatasetLocation location() {
        return this.location;
    }

    public BinaryDatasetTypeProperties withLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    public DatasetCompression compression() {
        return this.compression;
    }

    public BinaryDatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model BinaryDatasetTypeProperties"));
        }
        this.location().validate();
        if (this.compression() != null) {
            this.compression().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
        jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
        return jsonWriter.writeEndObject();
    }

    public static BinaryDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BinaryDatasetTypeProperties)jsonReader.readObject(reader -> {
            BinaryDatasetTypeProperties deserializedBinaryDatasetTypeProperties = new BinaryDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedBinaryDatasetTypeProperties.location = DatasetLocation.fromJson(reader);
                    continue;
                }
                if ("compression".equals(fieldName)) {
                    deserializedBinaryDatasetTypeProperties.compression = DatasetCompression.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBinaryDatasetTypeProperties;
        });
    }
}

