/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import java.io.IOException;

public final class AzureKeyVaultLinkedServiceTypeProperties
implements JsonSerializable<AzureKeyVaultLinkedServiceTypeProperties> {
    private Object baseUrl;
    private CredentialReference credential;
    private static final ClientLogger LOGGER = new ClientLogger(AzureKeyVaultLinkedServiceTypeProperties.class);

    public Object baseUrl() {
        return this.baseUrl;
    }

    public AzureKeyVaultLinkedServiceTypeProperties withBaseUrl(Object baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureKeyVaultLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.baseUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property baseUrl in model AzureKeyVaultLinkedServiceTypeProperties"));
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("baseUrl", this.baseUrl);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static AzureKeyVaultLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureKeyVaultLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureKeyVaultLinkedServiceTypeProperties deserializedAzureKeyVaultLinkedServiceTypeProperties = new AzureKeyVaultLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("baseUrl".equals(fieldName)) {
                    deserializedAzureKeyVaultLinkedServiceTypeProperties.baseUrl = reader.readUntyped();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureKeyVaultLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureKeyVaultLinkedServiceTypeProperties;
        });
    }
}

