/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureFunctionActivityMethod;
import java.io.IOException;
import java.util.Map;

public final class AzureFunctionActivityTypeProperties
implements JsonSerializable<AzureFunctionActivityTypeProperties> {
    private AzureFunctionActivityMethod method;
    private Object functionName;
    private Map<String, Object> headers;
    private Object body;
    private static final ClientLogger LOGGER = new ClientLogger(AzureFunctionActivityTypeProperties.class);

    public AzureFunctionActivityMethod method() {
        return this.method;
    }

    public AzureFunctionActivityTypeProperties withMethod(AzureFunctionActivityMethod method) {
        this.method = method;
        return this;
    }

    public Object functionName() {
        return this.functionName;
    }

    public AzureFunctionActivityTypeProperties withFunctionName(Object functionName) {
        this.functionName = functionName;
        return this;
    }

    public Map<String, Object> headers() {
        return this.headers;
    }

    public AzureFunctionActivityTypeProperties withHeaders(Map<String, Object> headers) {
        this.headers = headers;
        return this;
    }

    public Object body() {
        return this.body;
    }

    public AzureFunctionActivityTypeProperties withBody(Object body) {
        this.body = body;
        return this;
    }

    public void validate() {
        if (this.method() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property method in model AzureFunctionActivityTypeProperties"));
        }
        if (this.functionName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property functionName in model AzureFunctionActivityTypeProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
        jsonWriter.writeUntypedField("functionName", this.functionName);
        jsonWriter.writeMapField("headers", this.headers, (writer, element) -> writer.writeUntyped(element));
        if (this.body != null) {
            jsonWriter.writeUntypedField("body", this.body);
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureFunctionActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFunctionActivityTypeProperties)jsonReader.readObject(reader -> {
            AzureFunctionActivityTypeProperties deserializedAzureFunctionActivityTypeProperties = new AzureFunctionActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("method".equals(fieldName)) {
                    deserializedAzureFunctionActivityTypeProperties.method = AzureFunctionActivityMethod.fromString(reader.getString());
                    continue;
                }
                if ("functionName".equals(fieldName)) {
                    deserializedAzureFunctionActivityTypeProperties.functionName = reader.readUntyped();
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    Map headers;
                    deserializedAzureFunctionActivityTypeProperties.headers = headers = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedAzureFunctionActivityTypeProperties.body = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFunctionActivityTypeProperties;
        });
    }
}

