/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureBlobFSLinkedServiceTypeProperties
implements JsonSerializable<AzureBlobFSLinkedServiceTypeProperties> {
    private Object url;
    private Object accountKey;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object azureCloudType;
    private String encryptedCredential;
    private CredentialReference credential;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private Object sasUri;
    private SecretBase sasToken;

    public Object url() {
        return this.url;
    }

    public AzureBlobFSLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object accountKey() {
        return this.accountKey;
    }

    public AzureBlobFSLinkedServiceTypeProperties withAccountKey(Object accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureBlobFSLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureBlobFSLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public AzureBlobFSLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object azureCloudType() {
        return this.azureCloudType;
    }

    public AzureBlobFSLinkedServiceTypeProperties withAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureBlobFSLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureBlobFSLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public AzureBlobFSLinkedServiceTypeProperties withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase servicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public AzureBlobFSLinkedServiceTypeProperties withServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public Object sasUri() {
        return this.sasUri;
    }

    public AzureBlobFSLinkedServiceTypeProperties withSasUri(Object sasUri) {
        this.sasUri = sasUri;
        return this;
    }

    public SecretBase sasToken() {
        return this.sasToken;
    }

    public AzureBlobFSLinkedServiceTypeProperties withSasToken(SecretBase sasToken) {
        this.sasToken = sasToken;
        return this;
    }

    public void validate() {
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
        if (this.servicePrincipalCredential() != null) {
            this.servicePrincipalCredential().validate();
        }
        if (this.sasToken() != null) {
            this.sasToken().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.url != null) {
            jsonWriter.writeUntypedField("url", this.url);
        }
        if (this.accountKey != null) {
            jsonWriter.writeUntypedField("accountKey", this.accountKey);
        }
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        if (this.tenant != null) {
            jsonWriter.writeUntypedField("tenant", this.tenant);
        }
        if (this.azureCloudType != null) {
            jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        if (this.servicePrincipalCredentialType != null) {
            jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
        }
        jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
        if (this.sasUri != null) {
            jsonWriter.writeUntypedField("sasUri", this.sasUri);
        }
        jsonWriter.writeJsonField("sasToken", (JsonSerializable)this.sasToken);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobFSLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobFSLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureBlobFSLinkedServiceTypeProperties deserializedAzureBlobFSLinkedServiceTypeProperties = new AzureBlobFSLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedServiceTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedServiceTypeProperties.accountKey = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("azureCloudType".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedServiceTypeProperties.azureCloudType = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalCredentialType".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedServiceTypeProperties.servicePrincipalCredentialType = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredential".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedServiceTypeProperties.servicePrincipalCredential = SecretBase.fromJson(reader);
                    continue;
                }
                if ("sasUri".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedServiceTypeProperties.sasUri = reader.readUntyped();
                    continue;
                }
                if ("sasToken".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedServiceTypeProperties.sasToken = SecretBase.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBlobFSLinkedServiceTypeProperties;
        });
    }
}

