/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.TriggerOperation;
import com.azure.resourcemanager.cosmos.models.TriggerType;
import java.io.IOException;

public class SqlTriggerResource
implements JsonSerializable<SqlTriggerResource> {
    private String id;
    private String body;
    private TriggerType triggerType;
    private TriggerOperation triggerOperation;
    private static final ClientLogger LOGGER = new ClientLogger(SqlTriggerResource.class);

    public String id() {
        return this.id;
    }

    public SqlTriggerResource withId(String id) {
        this.id = id;
        return this;
    }

    public String body() {
        return this.body;
    }

    public SqlTriggerResource withBody(String body) {
        this.body = body;
        return this;
    }

    public TriggerType triggerType() {
        return this.triggerType;
    }

    public SqlTriggerResource withTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
        return this;
    }

    public TriggerOperation triggerOperation() {
        return this.triggerOperation;
    }

    public SqlTriggerResource withTriggerOperation(TriggerOperation triggerOperation) {
        this.triggerOperation = triggerOperation;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model SqlTriggerResource"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("body", this.body);
        jsonWriter.writeStringField("triggerType", this.triggerType == null ? null : this.triggerType.toString());
        jsonWriter.writeStringField("triggerOperation", this.triggerOperation == null ? null : this.triggerOperation.toString());
        return jsonWriter.writeEndObject();
    }

    public static SqlTriggerResource fromJson(JsonReader jsonReader) throws IOException {
        return (SqlTriggerResource)jsonReader.readObject(reader -> {
            SqlTriggerResource deserializedSqlTriggerResource = new SqlTriggerResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlTriggerResource.id = reader.getString();
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedSqlTriggerResource.body = reader.getString();
                    continue;
                }
                if ("triggerType".equals(fieldName)) {
                    deserializedSqlTriggerResource.triggerType = TriggerType.fromString(reader.getString());
                    continue;
                }
                if ("triggerOperation".equals(fieldName)) {
                    deserializedSqlTriggerResource.triggerOperation = TriggerOperation.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlTriggerResource;
        });
    }
}

