/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ManagedCassandraManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public class ManagedCassandraArmResourceProperties
extends Resource {
    private ManagedCassandraManagedServiceIdentity identity;
    private String type;
    private String name;
    private String id;

    public ManagedCassandraManagedServiceIdentity identity() {
        return this.identity;
    }

    public ManagedCassandraArmResourceProperties withIdentity(ManagedCassandraManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ManagedCassandraArmResourceProperties withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ManagedCassandraArmResourceProperties withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static ManagedCassandraArmResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedCassandraArmResourceProperties)((Object)jsonReader.readObject(reader -> {
            ManagedCassandraArmResourceProperties deserializedManagedCassandraArmResourceProperties = new ManagedCassandraArmResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedCassandraArmResourceProperties.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedCassandraArmResourceProperties.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedCassandraArmResourceProperties.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedManagedCassandraArmResourceProperties.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedCassandraArmResourceProperties.withTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedManagedCassandraArmResourceProperties.identity = ManagedCassandraManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedCassandraArmResourceProperties;
        }));
    }
}

