/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FullTextPath
implements JsonSerializable<FullTextPath> {
    private String path;
    private String language;
    private static final ClientLogger LOGGER = new ClientLogger(FullTextPath.class);

    public String path() {
        return this.path;
    }

    public FullTextPath withPath(String path) {
        this.path = path;
        return this;
    }

    public String language() {
        return this.language;
    }

    public FullTextPath withLanguage(String language) {
        this.language = language;
        return this;
    }

    public void validate() {
        if (this.path() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property path in model FullTextPath"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("language", this.language);
        return jsonWriter.writeEndObject();
    }

    public static FullTextPath fromJson(JsonReader jsonReader) throws IOException {
        return (FullTextPath)jsonReader.readObject(reader -> {
            FullTextPath deserializedFullTextPath = new FullTextPath();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedFullTextPath.path = reader.getString();
                    continue;
                }
                if ("language".equals(fieldName)) {
                    deserializedFullTextPath.language = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFullTextPath;
        });
    }
}

