/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.CassandraKeyspaceCreateUpdateProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.CassandraKeyspaceResource;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import java.io.IOException;
import java.util.Map;

public final class CassandraKeyspaceCreateUpdateParameters
extends ArmResourceProperties {
    private CassandraKeyspaceCreateUpdateProperties innerProperties = new CassandraKeyspaceCreateUpdateProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(CassandraKeyspaceCreateUpdateParameters.class);

    private CassandraKeyspaceCreateUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public CassandraKeyspaceCreateUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public CassandraKeyspaceCreateUpdateParameters withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public CassandraKeyspaceResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public CassandraKeyspaceCreateUpdateParameters withResource(CassandraKeyspaceResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CassandraKeyspaceCreateUpdateProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public CreateUpdateOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public CassandraKeyspaceCreateUpdateParameters withOptions(CreateUpdateOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CassandraKeyspaceCreateUpdateProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model CassandraKeyspaceCreateUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CassandraKeyspaceCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CassandraKeyspaceCreateUpdateParameters)((Object)jsonReader.readObject(reader -> {
            CassandraKeyspaceCreateUpdateParameters deserializedCassandraKeyspaceCreateUpdateParameters = new CassandraKeyspaceCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCassandraKeyspaceCreateUpdateParameters.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCassandraKeyspaceCreateUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCassandraKeyspaceCreateUpdateParameters.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCassandraKeyspaceCreateUpdateParameters.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCassandraKeyspaceCreateUpdateParameters.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCassandraKeyspaceCreateUpdateParameters.innerProperties = CassandraKeyspaceCreateUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCassandraKeyspaceCreateUpdateParameters;
        }));
    }
}

