/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.Certificate;
import java.io.IOException;
import java.util.List;

public final class AuthenticationMethodLdapProperties
implements JsonSerializable<AuthenticationMethodLdapProperties> {
    private String serverHostname;
    private Integer serverPort;
    private String serviceUserDistinguishedName;
    private String serviceUserPassword;
    private String searchBaseDistinguishedName;
    private String searchFilterTemplate;
    private List<Certificate> serverCertificates;
    private Integer connectionTimeoutInMs;

    public String serverHostname() {
        return this.serverHostname;
    }

    public AuthenticationMethodLdapProperties withServerHostname(String serverHostname) {
        this.serverHostname = serverHostname;
        return this;
    }

    public Integer serverPort() {
        return this.serverPort;
    }

    public AuthenticationMethodLdapProperties withServerPort(Integer serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    public String serviceUserDistinguishedName() {
        return this.serviceUserDistinguishedName;
    }

    public AuthenticationMethodLdapProperties withServiceUserDistinguishedName(String serviceUserDistinguishedName) {
        this.serviceUserDistinguishedName = serviceUserDistinguishedName;
        return this;
    }

    public String serviceUserPassword() {
        return this.serviceUserPassword;
    }

    public AuthenticationMethodLdapProperties withServiceUserPassword(String serviceUserPassword) {
        this.serviceUserPassword = serviceUserPassword;
        return this;
    }

    public String searchBaseDistinguishedName() {
        return this.searchBaseDistinguishedName;
    }

    public AuthenticationMethodLdapProperties withSearchBaseDistinguishedName(String searchBaseDistinguishedName) {
        this.searchBaseDistinguishedName = searchBaseDistinguishedName;
        return this;
    }

    public String searchFilterTemplate() {
        return this.searchFilterTemplate;
    }

    public AuthenticationMethodLdapProperties withSearchFilterTemplate(String searchFilterTemplate) {
        this.searchFilterTemplate = searchFilterTemplate;
        return this;
    }

    public List<Certificate> serverCertificates() {
        return this.serverCertificates;
    }

    public AuthenticationMethodLdapProperties withServerCertificates(List<Certificate> serverCertificates) {
        this.serverCertificates = serverCertificates;
        return this;
    }

    public Integer connectionTimeoutInMs() {
        return this.connectionTimeoutInMs;
    }

    public AuthenticationMethodLdapProperties withConnectionTimeoutInMs(Integer connectionTimeoutInMs) {
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        return this;
    }

    public void validate() {
        if (this.serverCertificates() != null) {
            this.serverCertificates().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverHostname", this.serverHostname);
        jsonWriter.writeNumberField("serverPort", (Number)this.serverPort);
        jsonWriter.writeStringField("serviceUserDistinguishedName", this.serviceUserDistinguishedName);
        jsonWriter.writeStringField("serviceUserPassword", this.serviceUserPassword);
        jsonWriter.writeStringField("searchBaseDistinguishedName", this.searchBaseDistinguishedName);
        jsonWriter.writeStringField("searchFilterTemplate", this.searchFilterTemplate);
        jsonWriter.writeArrayField("serverCertificates", this.serverCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("connectionTimeoutInMs", (Number)this.connectionTimeoutInMs);
        return jsonWriter.writeEndObject();
    }

    public static AuthenticationMethodLdapProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AuthenticationMethodLdapProperties)jsonReader.readObject(reader -> {
            AuthenticationMethodLdapProperties deserializedAuthenticationMethodLdapProperties = new AuthenticationMethodLdapProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serverHostname".equals(fieldName)) {
                    deserializedAuthenticationMethodLdapProperties.serverHostname = reader.getString();
                    continue;
                }
                if ("serverPort".equals(fieldName)) {
                    deserializedAuthenticationMethodLdapProperties.serverPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("serviceUserDistinguishedName".equals(fieldName)) {
                    deserializedAuthenticationMethodLdapProperties.serviceUserDistinguishedName = reader.getString();
                    continue;
                }
                if ("serviceUserPassword".equals(fieldName)) {
                    deserializedAuthenticationMethodLdapProperties.serviceUserPassword = reader.getString();
                    continue;
                }
                if ("searchBaseDistinguishedName".equals(fieldName)) {
                    deserializedAuthenticationMethodLdapProperties.searchBaseDistinguishedName = reader.getString();
                    continue;
                }
                if ("searchFilterTemplate".equals(fieldName)) {
                    deserializedAuthenticationMethodLdapProperties.searchFilterTemplate = reader.getString();
                    continue;
                }
                if ("serverCertificates".equals(fieldName)) {
                    List serverCertificates;
                    deserializedAuthenticationMethodLdapProperties.serverCertificates = serverCertificates = reader.readArray(reader1 -> Certificate.fromJson(reader1));
                    continue;
                }
                if ("connectionTimeoutInMs".equals(fieldName)) {
                    deserializedAuthenticationMethodLdapProperties.connectionTimeoutInMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthenticationMethodLdapProperties;
        });
    }
}

