/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ServerVersion;
import java.io.IOException;

public final class ApiProperties
implements JsonSerializable<ApiProperties> {
    private ServerVersion serverVersion;

    public ServerVersion serverVersion() {
        return this.serverVersion;
    }

    public ApiProperties withServerVersion(ServerVersion serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverVersion", this.serverVersion == null ? null : this.serverVersion.toString());
        return jsonWriter.writeEndObject();
    }

    public static ApiProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiProperties)jsonReader.readObject(reader -> {
            ApiProperties deserializedApiProperties = new ApiProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serverVersion".equals(fieldName)) {
                    deserializedApiProperties.serverVersion = ServerVersion.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiProperties;
        });
    }
}

