/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.TableResource;
import java.io.IOException;

public final class TableCreateUpdateProperties
implements JsonSerializable<TableCreateUpdateProperties> {
    private TableResource resource;
    private CreateUpdateOptions options;
    private static final ClientLogger LOGGER = new ClientLogger(TableCreateUpdateProperties.class);

    public TableResource resource() {
        return this.resource;
    }

    public TableCreateUpdateProperties withResource(TableResource resource) {
        this.resource = resource;
        return this;
    }

    public CreateUpdateOptions options() {
        return this.options;
    }

    public TableCreateUpdateProperties withOptions(CreateUpdateOptions options) {
        this.options = options;
        return this;
    }

    public void validate() {
        if (this.resource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resource in model TableCreateUpdateProperties"));
        }
        this.resource().validate();
        if (this.options() != null) {
            this.options().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resource", (JsonSerializable)this.resource);
        jsonWriter.writeJsonField("options", (JsonSerializable)this.options);
        return jsonWriter.writeEndObject();
    }

    public static TableCreateUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TableCreateUpdateProperties)jsonReader.readObject(reader -> {
            TableCreateUpdateProperties deserializedTableCreateUpdateProperties = new TableCreateUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resource".equals(fieldName)) {
                    deserializedTableCreateUpdateProperties.resource = TableResource.fromJson(reader);
                    continue;
                }
                if ("options".equals(fieldName)) {
                    deserializedTableCreateUpdateProperties.options = CreateUpdateOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableCreateUpdateProperties;
        });
    }
}

