/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.MetricInner;
import com.azure.resourcemanager.cosmos.models.MetricName;
import com.azure.resourcemanager.cosmos.models.MetricValue;
import com.azure.resourcemanager.cosmos.models.UnitType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class PartitionMetricInner
extends MetricInner {
    private String partitionId;
    private String partitionKeyRangeId;
    private List<MetricValue> metricValues;
    private MetricName name;
    private UnitType unit;
    private String timeGrain;
    private OffsetDateTime endTime;
    private OffsetDateTime startTime;

    public String partitionId() {
        return this.partitionId;
    }

    public String partitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }

    @Override
    public List<MetricValue> metricValues() {
        return this.metricValues;
    }

    @Override
    public MetricName name() {
        return this.name;
    }

    @Override
    public UnitType unit() {
        return this.unit;
    }

    @Override
    public String timeGrain() {
        return this.timeGrain;
    }

    @Override
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    @Override
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    @Override
    public void validate() {
        if (this.name() != null) {
            this.name().validate();
        }
        if (this.metricValues() != null) {
            this.metricValues().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static PartitionMetricInner fromJson(JsonReader jsonReader) throws IOException {
        return (PartitionMetricInner)jsonReader.readObject(reader -> {
            PartitionMetricInner deserializedPartitionMetricInner = new PartitionMetricInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedPartitionMetricInner.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedPartitionMetricInner.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("timeGrain".equals(fieldName)) {
                    deserializedPartitionMetricInner.timeGrain = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedPartitionMetricInner.unit = UnitType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPartitionMetricInner.name = MetricName.fromJson(reader);
                    continue;
                }
                if ("metricValues".equals(fieldName)) {
                    List metricValues;
                    deserializedPartitionMetricInner.metricValues = metricValues = reader.readArray(reader1 -> MetricValue.fromJson(reader1));
                    continue;
                }
                if ("partitionId".equals(fieldName)) {
                    deserializedPartitionMetricInner.partitionId = reader.getString();
                    continue;
                }
                if ("partitionKeyRangeId".equals(fieldName)) {
                    deserializedPartitionMetricInner.partitionKeyRangeId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartitionMetricInner;
        });
    }
}

