/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CassandraKeyspaceResource;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import java.io.IOException;

public final class CassandraKeyspaceCreateUpdateProperties
implements JsonSerializable<CassandraKeyspaceCreateUpdateProperties> {
    private CassandraKeyspaceResource resource;
    private CreateUpdateOptions options;
    private static final ClientLogger LOGGER = new ClientLogger(CassandraKeyspaceCreateUpdateProperties.class);

    public CassandraKeyspaceResource resource() {
        return this.resource;
    }

    public CassandraKeyspaceCreateUpdateProperties withResource(CassandraKeyspaceResource resource) {
        this.resource = resource;
        return this;
    }

    public CreateUpdateOptions options() {
        return this.options;
    }

    public CassandraKeyspaceCreateUpdateProperties withOptions(CreateUpdateOptions options) {
        this.options = options;
        return this;
    }

    public void validate() {
        if (this.resource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resource in model CassandraKeyspaceCreateUpdateProperties"));
        }
        this.resource().validate();
        if (this.options() != null) {
            this.options().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resource", (JsonSerializable)this.resource);
        jsonWriter.writeJsonField("options", (JsonSerializable)this.options);
        return jsonWriter.writeEndObject();
    }

    public static CassandraKeyspaceCreateUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CassandraKeyspaceCreateUpdateProperties)jsonReader.readObject(reader -> {
            CassandraKeyspaceCreateUpdateProperties deserializedCassandraKeyspaceCreateUpdateProperties = new CassandraKeyspaceCreateUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resource".equals(fieldName)) {
                    deserializedCassandraKeyspaceCreateUpdateProperties.resource = CassandraKeyspaceResource.fromJson(reader);
                    continue;
                }
                if ("options".equals(fieldName)) {
                    deserializedCassandraKeyspaceCreateUpdateProperties.options = CreateUpdateOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCassandraKeyspaceCreateUpdateProperties;
        });
    }
}

