/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Location
implements JsonSerializable<Location> {
    private String id;
    private String locationName;
    private String documentEndpoint;
    private String provisioningState;
    private Integer failoverPriority;
    private Boolean isZoneRedundant;

    public String id() {
        return this.id;
    }

    public String locationName() {
        return this.locationName;
    }

    public Location withLocationName(String locationName) {
        this.locationName = locationName;
        return this;
    }

    public String documentEndpoint() {
        return this.documentEndpoint;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Integer failoverPriority() {
        return this.failoverPriority;
    }

    public Location withFailoverPriority(Integer failoverPriority) {
        this.failoverPriority = failoverPriority;
        return this;
    }

    public Boolean isZoneRedundant() {
        return this.isZoneRedundant;
    }

    public Location withIsZoneRedundant(Boolean isZoneRedundant) {
        this.isZoneRedundant = isZoneRedundant;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("locationName", this.locationName);
        jsonWriter.writeNumberField("failoverPriority", (Number)this.failoverPriority);
        jsonWriter.writeBooleanField("isZoneRedundant", this.isZoneRedundant);
        return jsonWriter.writeEndObject();
    }

    public static Location fromJson(JsonReader jsonReader) throws IOException {
        return (Location)jsonReader.readObject(reader -> {
            Location deserializedLocation = new Location();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLocation.id = reader.getString();
                    continue;
                }
                if ("locationName".equals(fieldName)) {
                    deserializedLocation.locationName = reader.getString();
                    continue;
                }
                if ("documentEndpoint".equals(fieldName)) {
                    deserializedLocation.documentEndpoint = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedLocation.provisioningState = reader.getString();
                    continue;
                }
                if ("failoverPriority".equals(fieldName)) {
                    deserializedLocation.failoverPriority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isZoneRedundant".equals(fieldName)) {
                    deserializedLocation.isZoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocation;
        });
    }
}

