/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.IpTag;
import com.azure.resourcemanager.containerservice.models.PortRange;
import java.io.IOException;
import java.util.List;

public final class AgentPoolNetworkProfile
implements JsonSerializable<AgentPoolNetworkProfile> {
    private List<IpTag> nodePublicIpTags;
    private List<PortRange> allowedHostPorts;
    private List<String> applicationSecurityGroups;

    public List<IpTag> nodePublicIpTags() {
        return this.nodePublicIpTags;
    }

    public AgentPoolNetworkProfile withNodePublicIpTags(List<IpTag> nodePublicIpTags) {
        this.nodePublicIpTags = nodePublicIpTags;
        return this;
    }

    public List<PortRange> allowedHostPorts() {
        return this.allowedHostPorts;
    }

    public AgentPoolNetworkProfile withAllowedHostPorts(List<PortRange> allowedHostPorts) {
        this.allowedHostPorts = allowedHostPorts;
        return this;
    }

    public List<String> applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    public AgentPoolNetworkProfile withApplicationSecurityGroups(List<String> applicationSecurityGroups) {
        this.applicationSecurityGroups = applicationSecurityGroups;
        return this;
    }

    public void validate() {
        if (this.nodePublicIpTags() != null) {
            this.nodePublicIpTags().forEach(e -> e.validate());
        }
        if (this.allowedHostPorts() != null) {
            this.allowedHostPorts().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("nodePublicIPTags", this.nodePublicIpTags, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("allowedHostPorts", this.allowedHostPorts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("applicationSecurityGroups", this.applicationSecurityGroups, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AgentPoolNetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return (AgentPoolNetworkProfile)jsonReader.readObject(reader -> {
            AgentPoolNetworkProfile deserializedAgentPoolNetworkProfile = new AgentPoolNetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nodePublicIPTags".equals(fieldName)) {
                    List nodePublicIpTags;
                    deserializedAgentPoolNetworkProfile.nodePublicIpTags = nodePublicIpTags = reader.readArray(reader1 -> IpTag.fromJson(reader1));
                    continue;
                }
                if ("allowedHostPorts".equals(fieldName)) {
                    List allowedHostPorts;
                    deserializedAgentPoolNetworkProfile.allowedHostPorts = allowedHostPorts = reader.readArray(reader1 -> PortRange.fromJson(reader1));
                    continue;
                }
                if ("applicationSecurityGroups".equals(fieldName)) {
                    List applicationSecurityGroups;
                    deserializedAgentPoolNetworkProfile.applicationSecurityGroups = applicationSecurityGroups = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentPoolNetworkProfile;
        });
    }
}

