/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.AzureKeyVaultKms;
import com.azure.resourcemanager.containerservice.models.ManagedClusterSecurityProfileDefender;
import com.azure.resourcemanager.containerservice.models.ManagedClusterSecurityProfileImageCleaner;
import com.azure.resourcemanager.containerservice.models.ManagedClusterSecurityProfileWorkloadIdentity;
import java.io.IOException;
import java.util.List;

public final class ManagedClusterSecurityProfile
implements JsonSerializable<ManagedClusterSecurityProfile> {
    private ManagedClusterSecurityProfileDefender defender;
    private AzureKeyVaultKms azureKeyVaultKms;
    private ManagedClusterSecurityProfileWorkloadIdentity workloadIdentity;
    private ManagedClusterSecurityProfileImageCleaner imageCleaner;
    private List<byte[]> customCATrustCertificates;

    public ManagedClusterSecurityProfileDefender defender() {
        return this.defender;
    }

    public ManagedClusterSecurityProfile withDefender(ManagedClusterSecurityProfileDefender defender) {
        this.defender = defender;
        return this;
    }

    public AzureKeyVaultKms azureKeyVaultKms() {
        return this.azureKeyVaultKms;
    }

    public ManagedClusterSecurityProfile withAzureKeyVaultKms(AzureKeyVaultKms azureKeyVaultKms) {
        this.azureKeyVaultKms = azureKeyVaultKms;
        return this;
    }

    public ManagedClusterSecurityProfileWorkloadIdentity workloadIdentity() {
        return this.workloadIdentity;
    }

    public ManagedClusterSecurityProfile withWorkloadIdentity(ManagedClusterSecurityProfileWorkloadIdentity workloadIdentity) {
        this.workloadIdentity = workloadIdentity;
        return this;
    }

    public ManagedClusterSecurityProfileImageCleaner imageCleaner() {
        return this.imageCleaner;
    }

    public ManagedClusterSecurityProfile withImageCleaner(ManagedClusterSecurityProfileImageCleaner imageCleaner) {
        this.imageCleaner = imageCleaner;
        return this;
    }

    public List<byte[]> customCATrustCertificates() {
        return this.customCATrustCertificates;
    }

    public ManagedClusterSecurityProfile withCustomCATrustCertificates(List<byte[]> customCATrustCertificates) {
        this.customCATrustCertificates = customCATrustCertificates;
        return this;
    }

    public void validate() {
        if (this.defender() != null) {
            this.defender().validate();
        }
        if (this.azureKeyVaultKms() != null) {
            this.azureKeyVaultKms().validate();
        }
        if (this.workloadIdentity() != null) {
            this.workloadIdentity().validate();
        }
        if (this.imageCleaner() != null) {
            this.imageCleaner().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("defender", (JsonSerializable)this.defender);
        jsonWriter.writeJsonField("azureKeyVaultKms", (JsonSerializable)this.azureKeyVaultKms);
        jsonWriter.writeJsonField("workloadIdentity", (JsonSerializable)this.workloadIdentity);
        jsonWriter.writeJsonField("imageCleaner", (JsonSerializable)this.imageCleaner);
        jsonWriter.writeArrayField("customCATrustCertificates", this.customCATrustCertificates, (writer, element) -> writer.writeBinary(element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterSecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterSecurityProfile)jsonReader.readObject(reader -> {
            ManagedClusterSecurityProfile deserializedManagedClusterSecurityProfile = new ManagedClusterSecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("defender".equals(fieldName)) {
                    deserializedManagedClusterSecurityProfile.defender = ManagedClusterSecurityProfileDefender.fromJson(reader);
                    continue;
                }
                if ("azureKeyVaultKms".equals(fieldName)) {
                    deserializedManagedClusterSecurityProfile.azureKeyVaultKms = AzureKeyVaultKms.fromJson(reader);
                    continue;
                }
                if ("workloadIdentity".equals(fieldName)) {
                    deserializedManagedClusterSecurityProfile.workloadIdentity = ManagedClusterSecurityProfileWorkloadIdentity.fromJson(reader);
                    continue;
                }
                if ("imageCleaner".equals(fieldName)) {
                    deserializedManagedClusterSecurityProfile.imageCleaner = ManagedClusterSecurityProfileImageCleaner.fromJson(reader);
                    continue;
                }
                if ("customCATrustCertificates".equals(fieldName)) {
                    List customCATrustCertificates;
                    deserializedManagedClusterSecurityProfile.customCATrustCertificates = customCATrustCertificates = reader.readArray(reader1 -> reader1.getBinary());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterSecurityProfile;
        });
    }
}

