/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.management.Resource;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.containerservice.ContainerServiceManager;
import com.azure.resourcemanager.containerservice.fluent.ContainerServiceManagementClient;
import com.azure.resourcemanager.containerservice.fluent.models.AgentPoolInner;
import com.azure.resourcemanager.containerservice.fluent.models.ManagedClusterInner;
import com.azure.resourcemanager.containerservice.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.containerservice.fluent.models.PrivateEndpointConnectionListResultInner;
import com.azure.resourcemanager.containerservice.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.containerservice.fluent.models.PrivateLinkResourcesListResultInner;
import com.azure.resourcemanager.containerservice.implementation.AgentPoolDataImpl;
import com.azure.resourcemanager.containerservice.implementation.KubernetesClusterAgentPoolImpl;
import com.azure.resourcemanager.containerservice.implementation.KubernetesClusterNetworkProfileImpl;
import com.azure.resourcemanager.containerservice.models.AgentPool;
import com.azure.resourcemanager.containerservice.models.AgentPoolData;
import com.azure.resourcemanager.containerservice.models.ContainerServiceLinuxProfile;
import com.azure.resourcemanager.containerservice.models.ContainerServiceNetworkProfile;
import com.azure.resourcemanager.containerservice.models.ContainerServiceSshConfiguration;
import com.azure.resourcemanager.containerservice.models.ContainerServiceSshPublicKey;
import com.azure.resourcemanager.containerservice.models.CredentialResult;
import com.azure.resourcemanager.containerservice.models.Format;
import com.azure.resourcemanager.containerservice.models.KubernetesCluster;
import com.azure.resourcemanager.containerservice.models.KubernetesClusterAgentPool;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAadProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAddonProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAgentPoolProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterApiServerAccessProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterIdentity;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPropertiesAutoScalerProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterServicePrincipalProfile;
import com.azure.resourcemanager.containerservice.models.PowerState;
import com.azure.resourcemanager.containerservice.models.ResourceIdentityType;
import com.azure.resourcemanager.containerservice.models.UserAssignedIdentity;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpoint;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointConnectionProvisioningState;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointServiceConnectionStatus;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class KubernetesClusterImpl
extends GroupableResourceImpl<KubernetesCluster, ManagedClusterInner, KubernetesClusterImpl, ContainerServiceManager>
implements KubernetesCluster,
KubernetesCluster.Definition,
KubernetesCluster.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private List<CredentialResult> adminKubeConfigs;
    private List<CredentialResult> userKubeConfigs;
    private final Map<Format, List<CredentialResult>> formatUserKubeConfigsMap = new ConcurrentHashMap<Format, List<CredentialResult>>();
    private ManagedClusterInner parameterSnapshotOnUpdate;
    private static final SerializerAdapter SERIALIZER_ADAPTER = SerializerFactory.createDefaultManagementSerializerAdapter();

    protected KubernetesClusterImpl(String name, ManagedClusterInner innerObject, ContainerServiceManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
        if (((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles() == null) {
            ((ManagedClusterInner)((Object)this.innerModel())).withAgentPoolProfiles(new ArrayList<ManagedClusterAgentPoolProfile>());
        }
        this.adminKubeConfigs = null;
        this.userKubeConfigs = null;
    }

    @Override
    public String provisioningState() {
        return ((ManagedClusterInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public String dnsPrefix() {
        return ((ManagedClusterInner)((Object)this.innerModel())).dnsPrefix();
    }

    @Override
    public String fqdn() {
        return ((ManagedClusterInner)((Object)this.innerModel())).fqdn();
    }

    @Override
    public String version() {
        return ((ManagedClusterInner)((Object)this.innerModel())).kubernetesVersion();
    }

    @Override
    public List<CredentialResult> adminKubeConfigs() {
        if (this.adminKubeConfigs == null || this.adminKubeConfigs.size() == 0) {
            this.adminKubeConfigs = ((ContainerServiceManager)this.manager()).kubernetesClusters().listAdminKubeConfigContent(this.resourceGroupName(), this.name());
        }
        return Collections.unmodifiableList(this.adminKubeConfigs);
    }

    @Override
    public List<CredentialResult> userKubeConfigs() {
        if (this.userKubeConfigs == null || this.userKubeConfigs.size() == 0) {
            this.userKubeConfigs = ((ContainerServiceManager)this.manager()).kubernetesClusters().listUserKubeConfigContent(this.resourceGroupName(), this.name());
        }
        return Collections.unmodifiableList(this.userKubeConfigs);
    }

    @Override
    public List<CredentialResult> userKubeConfigs(Format format) {
        if (format == null) {
            return this.userKubeConfigs();
        }
        return Collections.unmodifiableList(this.formatUserKubeConfigsMap.computeIfAbsent(format, key -> ((ContainerServiceManager)this.manager()).kubernetesClusters().listUserKubeConfigContent(this.resourceGroupName(), this.name(), format)));
    }

    @Override
    public byte[] adminKubeConfigContent() {
        Iterator<CredentialResult> iterator = this.adminKubeConfigs().iterator();
        if (iterator.hasNext()) {
            CredentialResult config = iterator.next();
            return config.value();
        }
        return new byte[0];
    }

    @Override
    public byte[] userKubeConfigContent() {
        Iterator<CredentialResult> iterator = this.userKubeConfigs().iterator();
        if (iterator.hasNext()) {
            CredentialResult config = iterator.next();
            return config.value();
        }
        return new byte[0];
    }

    @Override
    public byte[] userKubeConfigContent(Format format) {
        if (format == null) {
            return this.userKubeConfigContent();
        }
        Iterator<CredentialResult> iterator = this.userKubeConfigs(format).iterator();
        if (iterator.hasNext()) {
            CredentialResult config = iterator.next();
            return config.value();
        }
        return new byte[0];
    }

    @Override
    public String servicePrincipalClientId() {
        if (((ManagedClusterInner)((Object)this.innerModel())).servicePrincipalProfile() != null) {
            return ((ManagedClusterInner)((Object)this.innerModel())).servicePrincipalProfile().clientId();
        }
        return null;
    }

    @Override
    public String servicePrincipalSecret() {
        if (((ManagedClusterInner)((Object)this.innerModel())).servicePrincipalProfile() != null) {
            return ((ManagedClusterInner)((Object)this.innerModel())).servicePrincipalProfile().secret();
        }
        return null;
    }

    @Override
    public String linuxRootUsername() {
        if (((ManagedClusterInner)((Object)this.innerModel())).linuxProfile() != null) {
            return ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().adminUsername();
        }
        return null;
    }

    @Override
    public String sshKey() {
        if (((ManagedClusterInner)((Object)this.innerModel())).linuxProfile() == null || ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().ssh() == null || ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().ssh().publicKeys() == null || ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().ssh().publicKeys().size() == 0) {
            return null;
        }
        return ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().ssh().publicKeys().get(0).keyData();
    }

    @Override
    public Map<String, KubernetesClusterAgentPool> agentPools() {
        HashMap<String, KubernetesClusterAgentPoolImpl> agentPoolMap = new HashMap<String, KubernetesClusterAgentPoolImpl>();
        if (((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles() != null && ((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles().size() > 0) {
            for (ManagedClusterAgentPoolProfile agentPoolProfile : ((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles()) {
                agentPoolMap.put(agentPoolProfile.name(), new KubernetesClusterAgentPoolImpl(agentPoolProfile, this));
            }
        }
        return Collections.unmodifiableMap(agentPoolMap);
    }

    @Override
    public ContainerServiceNetworkProfile networkProfile() {
        return ((ManagedClusterInner)((Object)this.innerModel())).networkProfile();
    }

    @Override
    public Map<String, ManagedClusterAddonProfile> addonProfiles() {
        return ((ManagedClusterInner)((Object)this.innerModel())).addonProfiles() == null ? Collections.emptyMap() : Collections.unmodifiableMap(((ManagedClusterInner)((Object)this.innerModel())).addonProfiles());
    }

    @Override
    public String nodeResourceGroup() {
        return ((ManagedClusterInner)((Object)this.innerModel())).nodeResourceGroup();
    }

    @Override
    public boolean enableRBAC() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ManagedClusterInner)((Object)this.innerModel())).enableRbac());
    }

    @Override
    public PowerState powerState() {
        return ((ManagedClusterInner)((Object)this.innerModel())).powerState();
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        UserAssignedIdentity identity;
        String objectId = null;
        if (((ManagedClusterInner)((Object)this.innerModel())).identityProfile() != null && (identity = ((ManagedClusterInner)((Object)this.innerModel())).identityProfile().get("kubeletidentity")) != null) {
            objectId = identity.objectId();
        }
        return objectId;
    }

    @Override
    public List<String> azureActiveDirectoryGroupIds() {
        if (((ManagedClusterInner)((Object)this.innerModel())).aadProfile() == null || CoreUtils.isNullOrEmpty(((ManagedClusterInner)((Object)this.innerModel())).aadProfile().adminGroupObjectIDs())) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(((ManagedClusterInner)((Object)this.innerModel())).aadProfile().adminGroupObjectIDs());
    }

    @Override
    public boolean isLocalAccountsEnabled() {
        return !ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ManagedClusterInner)((Object)this.innerModel())).disableLocalAccounts());
    }

    @Override
    public boolean isAzureRbacEnabled() {
        return ((ManagedClusterInner)((Object)this.innerModel())).aadProfile() != null && ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ManagedClusterInner)((Object)this.innerModel())).aadProfile().enableAzureRbac());
    }

    @Override
    public String diskEncryptionSetId() {
        return ((ManagedClusterInner)((Object)this.innerModel())).diskEncryptionSetId();
    }

    @Override
    public String agentPoolResourceGroup() {
        return ((ManagedClusterInner)((Object)this.innerModel())).nodeResourceGroup();
    }

    @Override
    public void start() {
        this.startAsync().block();
    }

    @Override
    public Mono<Void> startAsync() {
        return ((ContainerServiceManager)this.manager()).kubernetesClusters().startAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public void stop() {
        this.stopAsync().block();
    }

    @Override
    public Mono<Void> stopAsync() {
        return ((ContainerServiceManager)this.manager()).kubernetesClusters().stopAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Accepted<AgentPool> beginCreateAgentPool(String agentPoolName, AgentPoolData agentPool) {
        return AcceptedImpl.newAccepted((ClientLogger)this.logger, (HttpPipeline)((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getHttpPipeline(), (Duration)((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> (Response)((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getAgentPools().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.name(), agentPoolName, agentPool.innerModel()).block(), AgentPoolDataImpl::new, AgentPoolInner.class, null, (Context)Context.NONE);
    }

    protected Mono<ManagedClusterInner> getInnerAsync() {
        return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getManagedClusters().getByResourceGroupAsync(this.resourceGroupName(), this.name()).map(inner -> {
            this.clearKubeConfig();
            return inner;
        });
    }

    public KubernetesClusterImpl update() {
        this.parameterSnapshotOnUpdate = this.deepCopyInner();
        this.parameterSnapshotOnUpdate.withServicePrincipalProfile(null);
        return (KubernetesClusterImpl)super.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClusterModifiedDuringUpdate(ManagedClusterInner parameter) {
        if (this.parameterSnapshotOnUpdate == null || parameter == null) {
            return true;
        }
        List<ManagedClusterAgentPoolProfile> parameterSnapshotAgentPools = this.parameterSnapshotOnUpdate.agentPoolProfiles();
        List<ManagedClusterAgentPoolProfile> parameterAgentPools = parameter.agentPoolProfiles();
        Set intersectAgentPoolNames = parameter.agentPoolProfiles().stream().map(ManagedClusterAgentPoolProfile::name).collect(Collectors.toSet());
        intersectAgentPoolNames.retainAll(this.parameterSnapshotOnUpdate.agentPoolProfiles().stream().map(ManagedClusterAgentPoolProfile::name).collect(Collectors.toSet()));
        List<ManagedClusterAgentPoolProfile> agentPools = this.parameterSnapshotOnUpdate.agentPoolProfiles().stream().filter(p -> intersectAgentPoolNames.contains(p.name())).collect(Collectors.toList());
        this.parameterSnapshotOnUpdate.withAgentPoolProfiles(agentPools);
        agentPools = parameter.agentPoolProfiles().stream().filter(p -> intersectAgentPoolNames.contains(p.name())).collect(Collectors.toList());
        parameter.withAgentPoolProfiles(agentPools);
        try {
            String jsonStrSnapshot = SERIALIZER_ADAPTER.serialize((Object)this.parameterSnapshotOnUpdate, SerializerEncoding.JSON);
            String jsonStr = SERIALIZER_ADAPTER.serialize((Object)parameter, SerializerEncoding.JSON);
            boolean bl = !jsonStr.equals(jsonStrSnapshot);
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.parameterSnapshotOnUpdate.withAgentPoolProfiles(parameterSnapshotAgentPools);
            parameter.withAgentPoolProfiles(parameterAgentPools);
        }
    }

    ManagedClusterInner deepCopyInner() {
        ManagedClusterInner updateParameter;
        try {
            String jsonStr = SERIALIZER_ADAPTER.serialize(this.innerModel(), SerializerEncoding.JSON);
            updateParameter = (ManagedClusterInner)((Object)SERIALIZER_ADAPTER.deserialize(jsonStr, ManagedClusterInner.class, SerializerEncoding.JSON));
        }
        catch (IOException e) {
            updateParameter = null;
        }
        return updateParameter;
    }

    public Mono<KubernetesCluster> createResourceAsync() {
        boolean createOrModified;
        KubernetesClusterImpl self = this;
        if (!this.isInCreateMode()) {
            ((ManagedClusterInner)((Object)this.innerModel())).withServicePrincipalProfile(null);
        }
        boolean bl = createOrModified = this.isInCreateMode() || this.isClusterModifiedDuringUpdate((ManagedClusterInner)((Object)this.innerModel()));
        if (createOrModified) {
            return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getManagedClusters().createOrUpdateAsync(self.resourceGroupName(), self.name(), (ManagedClusterInner)((Object)self.innerModel())).map(inner -> {
                self.setInner(inner);
                this.clearKubeConfig();
                return self;
            });
        }
        return Mono.just((Object)this);
    }

    private void clearKubeConfig() {
        this.adminKubeConfigs = null;
        this.userKubeConfigs = null;
        this.formatUserKubeConfigsMap.clear();
    }

    @Override
    public KubernetesClusterImpl withVersion(String kubernetesVersion) {
        ((ManagedClusterInner)((Object)this.innerModel())).withKubernetesVersion(kubernetesVersion);
        return this;
    }

    @Override
    public KubernetesClusterImpl withDefaultVersion() {
        ((ManagedClusterInner)((Object)this.innerModel())).withKubernetesVersion("");
        return this;
    }

    @Override
    public KubernetesClusterImpl withRootUsername(String rootUserName) {
        if (((ManagedClusterInner)((Object)this.innerModel())).linuxProfile() == null) {
            ((ManagedClusterInner)((Object)this.innerModel())).withLinuxProfile(new ContainerServiceLinuxProfile());
        }
        ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().withAdminUsername(rootUserName);
        return this;
    }

    @Override
    public KubernetesClusterImpl withSshKey(String sshKeyData) {
        ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().withSsh(new ContainerServiceSshConfiguration().withPublicKeys(new ArrayList<ContainerServiceSshPublicKey>()));
        ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().ssh().publicKeys().add(new ContainerServiceSshPublicKey().withKeyData(sshKeyData));
        return this;
    }

    @Override
    public KubernetesClusterImpl withServicePrincipalClientId(String clientId) {
        ((ManagedClusterInner)((Object)this.innerModel())).withServicePrincipalProfile(new ManagedClusterServicePrincipalProfile().withClientId(clientId));
        return this;
    }

    @Override
    public KubernetesClusterImpl withSystemAssignedManagedServiceIdentity() {
        ((ManagedClusterInner)((Object)this.innerModel())).withIdentity(new ManagedClusterIdentity().withType(ResourceIdentityType.SYSTEM_ASSIGNED));
        return this;
    }

    @Override
    public KubernetesClusterImpl withServicePrincipalSecret(String secret) {
        ((ManagedClusterInner)((Object)this.innerModel())).servicePrincipalProfile().withSecret(secret);
        return this;
    }

    @Override
    public KubernetesClusterImpl withDnsPrefix(String dnsPrefix) {
        ((ManagedClusterInner)((Object)this.innerModel())).withDnsPrefix(dnsPrefix);
        return this;
    }

    public KubernetesClusterAgentPoolImpl defineAgentPool(String name) {
        ManagedClusterAgentPoolProfile innerPoolProfile = new ManagedClusterAgentPoolProfile().withName(name).withOrchestratorVersion(((ManagedClusterInner)((Object)this.innerModel())).kubernetesVersion());
        return new KubernetesClusterAgentPoolImpl(innerPoolProfile, this);
    }

    public KubernetesClusterAgentPoolImpl updateAgentPool(String name) {
        for (ManagedClusterAgentPoolProfile agentPoolProfile : ((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles()) {
            if (!agentPoolProfile.name().equals(name)) continue;
            return new KubernetesClusterAgentPoolImpl(agentPoolProfile, this);
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("Cannot get agent pool named %s", name)));
    }

    @Override
    public KubernetesCluster.Update withoutAgentPool(String name) {
        if (((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles() != null) {
            ((ManagedClusterInner)((Object)this.innerModel())).withAgentPoolProfiles(((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles().stream().filter(p -> !name.equals(p.name())).collect(Collectors.toList()));
            this.addDependency(context -> ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getAgentPools().deleteAsync(this.resourceGroupName(), this.name(), name).then(context.voidMono()));
        }
        return this;
    }

    @Override
    public KubernetesCluster.DefinitionStages.NetworkProfileDefinitionStages.Blank<KubernetesCluster.DefinitionStages.WithCreate> defineNetworkProfile() {
        return new KubernetesClusterNetworkProfileImpl(this);
    }

    @Override
    public KubernetesClusterImpl withAddOnProfiles(Map<String, ManagedClusterAddonProfile> addOnProfileMap) {
        ((ManagedClusterInner)((Object)this.innerModel())).withAddonProfiles(addOnProfileMap);
        return this;
    }

    @Override
    public KubernetesClusterImpl withNetworkProfile(ContainerServiceNetworkProfile networkProfile) {
        ((ManagedClusterInner)((Object)this.innerModel())).withNetworkProfile(networkProfile);
        return this;
    }

    @Override
    public KubernetesClusterImpl withRBACEnabled() {
        ((ManagedClusterInner)((Object)this.innerModel())).withEnableRbac(true);
        return this;
    }

    @Override
    public KubernetesClusterImpl withRBACDisabled() {
        ((ManagedClusterInner)((Object)this.innerModel())).withEnableRbac(false);
        return this;
    }

    public KubernetesClusterImpl addNewAgentPool(KubernetesClusterAgentPoolImpl agentPool) {
        if (!this.isInCreateMode()) {
            this.addDependency(context -> ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getAgentPools().createOrUpdateAsync(this.resourceGroupName(), this.name(), agentPool.name(), agentPool.getAgentPoolInner()).then(context.voidMono()));
        }
        ((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles().add((ManagedClusterAgentPoolProfile)agentPool.innerModel());
        return this;
    }

    @Override
    public KubernetesClusterImpl withAutoScalerProfile(ManagedClusterPropertiesAutoScalerProfile autoScalerProfile) {
        ((ManagedClusterInner)((Object)this.innerModel())).withAutoScalerProfile(autoScalerProfile);
        return this;
    }

    @Override
    public KubernetesClusterImpl enablePrivateCluster() {
        if (((ManagedClusterInner)((Object)this.innerModel())).apiServerAccessProfile() == null) {
            ((ManagedClusterInner)((Object)this.innerModel())).withApiServerAccessProfile(new ManagedClusterApiServerAccessProfile());
        }
        ((ManagedClusterInner)((Object)this.innerModel())).apiServerAccessProfile().withEnablePrivateCluster(true);
        return this;
    }

    public PagedIterable<PrivateLinkResource> listPrivateLinkResources() {
        return new PagedIterable(this.listPrivateLinkResourcesAsync());
    }

    public PagedFlux<PrivateLinkResource> listPrivateLinkResourcesAsync() {
        Mono retList = ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getPrivateLinkResources().listWithResponseAsync(this.resourceGroupName(), this.name()).map(response -> new SimpleResponse(response, ((PrivateLinkResourcesListResultInner)response.getValue()).value().stream().map(x$0 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)x$0)).collect(Collectors.toList())));
        return PagedConverter.convertListToPagedFlux((Mono)retList);
    }

    public PagedIterable<PrivateEndpointConnection> listPrivateEndpointConnections() {
        return new PagedIterable(this.listPrivateEndpointConnectionsAsync());
    }

    public PagedFlux<PrivateEndpointConnection> listPrivateEndpointConnectionsAsync() {
        Mono retList = ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getPrivateEndpointConnections().listWithResponseAsync(this.resourceGroupName(), this.name()).map(response -> new SimpleResponse(response, ((PrivateEndpointConnectionListResultInner)response.getValue()).value().stream().map(x$0 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)((Object)x$0)))).collect(Collectors.toList())));
        return PagedConverter.convertListToPagedFlux((Mono)retList);
    }

    @Override
    public KubernetesClusterImpl withAzureActiveDirectoryGroup(String activeDirectoryGroupObjectId) {
        this.withRBACEnabled();
        if (((ManagedClusterInner)((Object)this.innerModel())).aadProfile() == null) {
            ((ManagedClusterInner)((Object)this.innerModel())).withAadProfile(new ManagedClusterAadProfile().withManaged(true));
        }
        if (((ManagedClusterInner)((Object)this.innerModel())).aadProfile().adminGroupObjectIDs() == null) {
            ((ManagedClusterInner)((Object)this.innerModel())).aadProfile().withAdminGroupObjectIDs(new ArrayList<String>());
        }
        ((ManagedClusterInner)((Object)this.innerModel())).aadProfile().adminGroupObjectIDs().add(activeDirectoryGroupObjectId);
        return this;
    }

    @Override
    public KubernetesClusterImpl enableAzureRbac() {
        this.withRBACEnabled();
        if (((ManagedClusterInner)((Object)this.innerModel())).aadProfile() == null) {
            ((ManagedClusterInner)((Object)this.innerModel())).withAadProfile(new ManagedClusterAadProfile().withManaged(true));
        }
        ((ManagedClusterInner)((Object)this.innerModel())).aadProfile().withEnableAzureRbac(true);
        return this;
    }

    @Override
    public KubernetesClusterImpl enableLocalAccounts() {
        ((ManagedClusterInner)((Object)this.innerModel())).withDisableLocalAccounts(false);
        return this;
    }

    @Override
    public KubernetesClusterImpl disableLocalAccounts() {
        ((ManagedClusterInner)((Object)this.innerModel())).withDisableLocalAccounts(true);
        return this;
    }

    @Override
    public KubernetesClusterImpl disableKubernetesRbac() {
        ((ManagedClusterInner)((Object)this.innerModel())).withEnableRbac(false);
        return this;
    }

    @Override
    public KubernetesClusterImpl withDiskEncryptionSet(String diskEncryptionSetId) {
        ((ManagedClusterInner)((Object)this.innerModel())).withDiskEncryptionSetId(diskEncryptionSetId);
        return this;
    }

    @Override
    public KubernetesClusterImpl withAgentPoolResourceGroup(String resourceGroupName) {
        ((ManagedClusterInner)((Object)this.innerModel())).withNodeResourceGroup(resourceGroupName);
        return this;
    }

    private static final class PrivateEndpointConnectionImpl
    implements PrivateEndpointConnection {
        private final PrivateEndpointConnectionInner innerModel;
        private final PrivateEndpoint privateEndpoint;
        private final PrivateLinkServiceConnectionState privateLinkServiceConnectionState;
        private final PrivateEndpointConnectionProvisioningState provisioningState;

        private PrivateEndpointConnectionImpl(PrivateEndpointConnectionInner innerModel) {
            this.innerModel = innerModel;
            PrivateEndpoint privateEndpoint = this.privateEndpoint = innerModel.privateEndpoint() == null ? null : new PrivateEndpoint(innerModel.privateEndpoint().id());
            this.privateLinkServiceConnectionState = innerModel.privateLinkServiceConnectionState() == null ? null : new PrivateLinkServiceConnectionState(innerModel.privateLinkServiceConnectionState().status() == null ? null : PrivateEndpointServiceConnectionStatus.fromString((String)innerModel.privateLinkServiceConnectionState().status().toString()), innerModel.privateLinkServiceConnectionState().description(), "");
            this.provisioningState = innerModel.provisioningState() == null ? null : PrivateEndpointConnectionProvisioningState.fromString((String)innerModel.provisioningState().toString());
        }

        public String id() {
            return this.innerModel.id();
        }

        public String name() {
            return this.innerModel.name();
        }

        public String type() {
            return this.innerModel.type();
        }

        public PrivateEndpoint privateEndpoint() {
            return this.privateEndpoint;
        }

        public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
            return this.privateLinkServiceConnectionState;
        }

        public PrivateEndpointConnectionProvisioningState provisioningState() {
            return this.provisioningState;
        }
    }

    private static final class PrivateLinkResourceImpl
    implements PrivateLinkResource {
        private final PrivateLinkResourceInner innerModel;

        private PrivateLinkResourceImpl(PrivateLinkResourceInner innerModel) {
            this.innerModel = innerModel;
        }

        public String groupId() {
            return this.innerModel.groupId();
        }

        public List<String> requiredMemberNames() {
            return Collections.unmodifiableList(this.innerModel.requiredMembers());
        }

        public List<String> requiredDnsZoneNames() {
            return Collections.emptyList();
        }
    }
}

