/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.Argument;
import com.azure.resourcemanager.containerregistry.models.SetValue;
import java.io.IOException;
import java.util.List;

public final class OverrideTaskStepProperties
implements JsonSerializable<OverrideTaskStepProperties> {
    private String contextPath;
    private String file;
    private List<Argument> arguments;
    private String target;
    private List<SetValue> values;
    private String updateTriggerToken;

    public String contextPath() {
        return this.contextPath;
    }

    public OverrideTaskStepProperties withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public String file() {
        return this.file;
    }

    public OverrideTaskStepProperties withFile(String file) {
        this.file = file;
        return this;
    }

    public List<Argument> arguments() {
        return this.arguments;
    }

    public OverrideTaskStepProperties withArguments(List<Argument> arguments) {
        this.arguments = arguments;
        return this;
    }

    public String target() {
        return this.target;
    }

    public OverrideTaskStepProperties withTarget(String target) {
        this.target = target;
        return this;
    }

    public List<SetValue> values() {
        return this.values;
    }

    public OverrideTaskStepProperties withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    public String updateTriggerToken() {
        return this.updateTriggerToken;
    }

    public OverrideTaskStepProperties withUpdateTriggerToken(String updateTriggerToken) {
        this.updateTriggerToken = updateTriggerToken;
        return this;
    }

    public void validate() {
        if (this.arguments() != null) {
            this.arguments().forEach(e -> e.validate());
        }
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contextPath", this.contextPath);
        jsonWriter.writeStringField("file", this.file);
        jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("updateTriggerToken", this.updateTriggerToken);
        return jsonWriter.writeEndObject();
    }

    public static OverrideTaskStepProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OverrideTaskStepProperties)jsonReader.readObject(reader -> {
            OverrideTaskStepProperties deserializedOverrideTaskStepProperties = new OverrideTaskStepProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contextPath".equals(fieldName)) {
                    deserializedOverrideTaskStepProperties.contextPath = reader.getString();
                    continue;
                }
                if ("file".equals(fieldName)) {
                    deserializedOverrideTaskStepProperties.file = reader.getString();
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    List arguments;
                    deserializedOverrideTaskStepProperties.arguments = arguments = reader.readArray(reader1 -> Argument.fromJson(reader1));
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedOverrideTaskStepProperties.target = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedOverrideTaskStepProperties.values = values = reader.readArray(reader1 -> SetValue.fromJson(reader1));
                    continue;
                }
                if ("updateTriggerToken".equals(fieldName)) {
                    deserializedOverrideTaskStepProperties.updateTriggerToken = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOverrideTaskStepProperties;
        });
    }
}

