/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.CredentialSetUpdateProperties;
import com.azure.resourcemanager.containerregistry.models.AuthCredential;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import java.io.IOException;
import java.util.List;

public final class CredentialSetUpdateParameters
implements JsonSerializable<CredentialSetUpdateParameters> {
    private CredentialSetUpdateProperties innerProperties;
    private IdentityProperties identity;

    private CredentialSetUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public IdentityProperties identity() {
        return this.identity;
    }

    public CredentialSetUpdateParameters withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    public List<AuthCredential> authCredentials() {
        return this.innerProperties() == null ? null : this.innerProperties().authCredentials();
    }

    public CredentialSetUpdateParameters withAuthCredentials(List<AuthCredential> authCredentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CredentialSetUpdateProperties();
        }
        this.innerProperties().withAuthCredentials(authCredentials);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static CredentialSetUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CredentialSetUpdateParameters)jsonReader.readObject(reader -> {
            CredentialSetUpdateParameters deserializedCredentialSetUpdateParameters = new CredentialSetUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedCredentialSetUpdateParameters.innerProperties = CredentialSetUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedCredentialSetUpdateParameters.identity = IdentityProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentialSetUpdateParameters;
        });
    }
}

