/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Argument
implements JsonSerializable<Argument> {
    private String name;
    private String value;
    private Boolean isSecret;
    private static final ClientLogger LOGGER = new ClientLogger(Argument.class);

    public String name() {
        return this.name;
    }

    public Argument withName(String name) {
        this.name = name;
        return this;
    }

    public String value() {
        return this.value;
    }

    public Argument withValue(String value) {
        this.value = value;
        return this;
    }

    public Boolean isSecret() {
        return this.isSecret;
    }

    public Argument withIsSecret(Boolean isSecret) {
        this.isSecret = isSecret;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Argument"));
        }
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model Argument"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeBooleanField("isSecret", this.isSecret);
        return jsonWriter.writeEndObject();
    }

    public static Argument fromJson(JsonReader jsonReader) throws IOException {
        return (Argument)jsonReader.readObject(reader -> {
            Argument deserializedArgument = new Argument();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedArgument.name = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedArgument.value = reader.getString();
                    continue;
                }
                if ("isSecret".equals(fieldName)) {
                    deserializedArgument.isSecret = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedArgument;
        });
    }
}

