// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The properties for updating triggers.
 */
@Fluent
public final class TriggerUpdateParameters implements JsonSerializable<TriggerUpdateParameters> {
    /*
     * The collection of timer triggers.
     */
    private List<TimerTriggerUpdateParameters> timerTriggers;

    /*
     * The collection of triggers based on source code repository.
     */
    private List<SourceTriggerUpdateParameters> sourceTriggers;

    /*
     * The trigger based on base image dependencies.
     */
    private BaseImageTriggerUpdateParameters baseImageTrigger;

    /**
     * Creates an instance of TriggerUpdateParameters class.
     */
    public TriggerUpdateParameters() {
    }

    /**
     * Get the timerTriggers property: The collection of timer triggers.
     * 
     * @return the timerTriggers value.
     */
    public List<TimerTriggerUpdateParameters> timerTriggers() {
        return this.timerTriggers;
    }

    /**
     * Set the timerTriggers property: The collection of timer triggers.
     * 
     * @param timerTriggers the timerTriggers value to set.
     * @return the TriggerUpdateParameters object itself.
     */
    public TriggerUpdateParameters withTimerTriggers(List<TimerTriggerUpdateParameters> timerTriggers) {
        this.timerTriggers = timerTriggers;
        return this;
    }

    /**
     * Get the sourceTriggers property: The collection of triggers based on source code repository.
     * 
     * @return the sourceTriggers value.
     */
    public List<SourceTriggerUpdateParameters> sourceTriggers() {
        return this.sourceTriggers;
    }

    /**
     * Set the sourceTriggers property: The collection of triggers based on source code repository.
     * 
     * @param sourceTriggers the sourceTriggers value to set.
     * @return the TriggerUpdateParameters object itself.
     */
    public TriggerUpdateParameters withSourceTriggers(List<SourceTriggerUpdateParameters> sourceTriggers) {
        this.sourceTriggers = sourceTriggers;
        return this;
    }

    /**
     * Get the baseImageTrigger property: The trigger based on base image dependencies.
     * 
     * @return the baseImageTrigger value.
     */
    public BaseImageTriggerUpdateParameters baseImageTrigger() {
        return this.baseImageTrigger;
    }

    /**
     * Set the baseImageTrigger property: The trigger based on base image dependencies.
     * 
     * @param baseImageTrigger the baseImageTrigger value to set.
     * @return the TriggerUpdateParameters object itself.
     */
    public TriggerUpdateParameters withBaseImageTrigger(BaseImageTriggerUpdateParameters baseImageTrigger) {
        this.baseImageTrigger = baseImageTrigger;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (timerTriggers() != null) {
            timerTriggers().forEach(e -> e.validate());
        }
        if (sourceTriggers() != null) {
            sourceTriggers().forEach(e -> e.validate());
        }
        if (baseImageTrigger() != null) {
            baseImageTrigger().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("timerTriggers", this.timerTriggers, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("sourceTriggers", this.sourceTriggers,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("baseImageTrigger", this.baseImageTrigger);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TriggerUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TriggerUpdateParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TriggerUpdateParameters.
     */
    public static TriggerUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TriggerUpdateParameters deserializedTriggerUpdateParameters = new TriggerUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timerTriggers".equals(fieldName)) {
                    List<TimerTriggerUpdateParameters> timerTriggers
                        = reader.readArray(reader1 -> TimerTriggerUpdateParameters.fromJson(reader1));
                    deserializedTriggerUpdateParameters.timerTriggers = timerTriggers;
                } else if ("sourceTriggers".equals(fieldName)) {
                    List<SourceTriggerUpdateParameters> sourceTriggers
                        = reader.readArray(reader1 -> SourceTriggerUpdateParameters.fromJson(reader1));
                    deserializedTriggerUpdateParameters.sourceTriggers = sourceTriggers;
                } else if ("baseImageTrigger".equals(fieldName)) {
                    deserializedTriggerUpdateParameters.baseImageTrigger
                        = BaseImageTriggerUpdateParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTriggerUpdateParameters;
        });
    }
}
