// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The source trigger that caused a run.
 */
@Fluent
public final class SourceTriggerDescriptor implements JsonSerializable<SourceTriggerDescriptor> {
    /*
     * The unique ID of the trigger.
     */
    private String id;

    /*
     * The event type of the trigger.
     */
    private String eventType;

    /*
     * The unique ID that identifies a commit.
     */
    private String commitId;

    /*
     * The unique ID that identifies pull request.
     */
    private String pullRequestId;

    /*
     * The repository URL.
     */
    private String repositoryUrl;

    /*
     * The branch name in the repository.
     */
    private String branchName;

    /*
     * The source control provider type.
     */
    private String providerType;

    /**
     * Creates an instance of SourceTriggerDescriptor class.
     */
    public SourceTriggerDescriptor() {
    }

    /**
     * Get the id property: The unique ID of the trigger.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The unique ID of the trigger.
     * 
     * @param id the id value to set.
     * @return the SourceTriggerDescriptor object itself.
     */
    public SourceTriggerDescriptor withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the eventType property: The event type of the trigger.
     * 
     * @return the eventType value.
     */
    public String eventType() {
        return this.eventType;
    }

    /**
     * Set the eventType property: The event type of the trigger.
     * 
     * @param eventType the eventType value to set.
     * @return the SourceTriggerDescriptor object itself.
     */
    public SourceTriggerDescriptor withEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    /**
     * Get the commitId property: The unique ID that identifies a commit.
     * 
     * @return the commitId value.
     */
    public String commitId() {
        return this.commitId;
    }

    /**
     * Set the commitId property: The unique ID that identifies a commit.
     * 
     * @param commitId the commitId value to set.
     * @return the SourceTriggerDescriptor object itself.
     */
    public SourceTriggerDescriptor withCommitId(String commitId) {
        this.commitId = commitId;
        return this;
    }

    /**
     * Get the pullRequestId property: The unique ID that identifies pull request.
     * 
     * @return the pullRequestId value.
     */
    public String pullRequestId() {
        return this.pullRequestId;
    }

    /**
     * Set the pullRequestId property: The unique ID that identifies pull request.
     * 
     * @param pullRequestId the pullRequestId value to set.
     * @return the SourceTriggerDescriptor object itself.
     */
    public SourceTriggerDescriptor withPullRequestId(String pullRequestId) {
        this.pullRequestId = pullRequestId;
        return this;
    }

    /**
     * Get the repositoryUrl property: The repository URL.
     * 
     * @return the repositoryUrl value.
     */
    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    /**
     * Set the repositoryUrl property: The repository URL.
     * 
     * @param repositoryUrl the repositoryUrl value to set.
     * @return the SourceTriggerDescriptor object itself.
     */
    public SourceTriggerDescriptor withRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    /**
     * Get the branchName property: The branch name in the repository.
     * 
     * @return the branchName value.
     */
    public String branchName() {
        return this.branchName;
    }

    /**
     * Set the branchName property: The branch name in the repository.
     * 
     * @param branchName the branchName value to set.
     * @return the SourceTriggerDescriptor object itself.
     */
    public SourceTriggerDescriptor withBranchName(String branchName) {
        this.branchName = branchName;
        return this;
    }

    /**
     * Get the providerType property: The source control provider type.
     * 
     * @return the providerType value.
     */
    public String providerType() {
        return this.providerType;
    }

    /**
     * Set the providerType property: The source control provider type.
     * 
     * @param providerType the providerType value to set.
     * @return the SourceTriggerDescriptor object itself.
     */
    public SourceTriggerDescriptor withProviderType(String providerType) {
        this.providerType = providerType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("eventType", this.eventType);
        jsonWriter.writeStringField("commitId", this.commitId);
        jsonWriter.writeStringField("pullRequestId", this.pullRequestId);
        jsonWriter.writeStringField("repositoryUrl", this.repositoryUrl);
        jsonWriter.writeStringField("branchName", this.branchName);
        jsonWriter.writeStringField("providerType", this.providerType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SourceTriggerDescriptor from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SourceTriggerDescriptor if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SourceTriggerDescriptor.
     */
    public static SourceTriggerDescriptor fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SourceTriggerDescriptor deserializedSourceTriggerDescriptor = new SourceTriggerDescriptor();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSourceTriggerDescriptor.id = reader.getString();
                } else if ("eventType".equals(fieldName)) {
                    deserializedSourceTriggerDescriptor.eventType = reader.getString();
                } else if ("commitId".equals(fieldName)) {
                    deserializedSourceTriggerDescriptor.commitId = reader.getString();
                } else if ("pullRequestId".equals(fieldName)) {
                    deserializedSourceTriggerDescriptor.pullRequestId = reader.getString();
                } else if ("repositoryUrl".equals(fieldName)) {
                    deserializedSourceTriggerDescriptor.repositoryUrl = reader.getString();
                } else if ("branchName".equals(fieldName)) {
                    deserializedSourceTriggerDescriptor.branchName = reader.getString();
                } else if ("providerType".equals(fieldName)) {
                    deserializedSourceTriggerDescriptor.providerType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSourceTriggerDescriptor;
        });
    }
}
