// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The login password for the container registry.
 */
@Fluent
public final class RegistryPassword implements JsonSerializable<RegistryPassword> {
    /*
     * The password name.
     */
    private PasswordName name;

    /*
     * The password value.
     */
    private String value;

    /**
     * Creates an instance of RegistryPassword class.
     */
    public RegistryPassword() {
    }

    /**
     * Get the name property: The password name.
     * 
     * @return the name value.
     */
    public PasswordName name() {
        return this.name;
    }

    /**
     * Set the name property: The password name.
     * 
     * @param name the name value to set.
     * @return the RegistryPassword object itself.
     */
    public RegistryPassword withName(PasswordName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The password value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The password value.
     * 
     * @param value the value value to set.
     * @return the RegistryPassword object itself.
     */
    public RegistryPassword withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RegistryPassword from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RegistryPassword if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RegistryPassword.
     */
    public static RegistryPassword fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RegistryPassword deserializedRegistryPassword = new RegistryPassword();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedRegistryPassword.name = PasswordName.fromString(reader.getString());
                } else if ("value".equals(fieldName)) {
                    deserializedRegistryPassword.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRegistryPassword;
        });
    }
}
