// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.Credentials;
import com.azure.resourcemanager.containerregistry.models.PlatformUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.TaskStatus;
import com.azure.resourcemanager.containerregistry.models.TaskStepUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.TriggerUpdateParameters;
import java.io.IOException;

/**
 * The properties for updating a task.
 */
@Fluent
public final class TaskPropertiesUpdateParameters implements JsonSerializable<TaskPropertiesUpdateParameters> {
    /*
     * The current status of task.
     */
    private TaskStatus status;

    /*
     * The platform properties against which the run has to happen.
     */
    private PlatformUpdateParameters platform;

    /*
     * The machine configuration of the run agent.
     */
    private AgentProperties agentConfiguration;

    /*
     * The dedicated agent pool for the task.
     */
    private String agentPoolName;

    /*
     * Run timeout in seconds.
     */
    private Integer timeout;

    /*
     * The properties for updating a task step.
     */
    private TaskStepUpdateParameters step;

    /*
     * The properties for updating trigger properties.
     */
    private TriggerUpdateParameters trigger;

    /*
     * The parameters that describes a set of credentials that will be used when this run is invoked.
     */
    private Credentials credentials;

    /*
     * The template that describes the repository and tag information for run log artifact.
     */
    private String logTemplate;

    /**
     * Creates an instance of TaskPropertiesUpdateParameters class.
     */
    public TaskPropertiesUpdateParameters() {
    }

    /**
     * Get the status property: The current status of task.
     * 
     * @return the status value.
     */
    public TaskStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The current status of task.
     * 
     * @param status the status value to set.
     * @return the TaskPropertiesUpdateParameters object itself.
     */
    public TaskPropertiesUpdateParameters withStatus(TaskStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the platform property: The platform properties against which the run has to happen.
     * 
     * @return the platform value.
     */
    public PlatformUpdateParameters platform() {
        return this.platform;
    }

    /**
     * Set the platform property: The platform properties against which the run has to happen.
     * 
     * @param platform the platform value to set.
     * @return the TaskPropertiesUpdateParameters object itself.
     */
    public TaskPropertiesUpdateParameters withPlatform(PlatformUpdateParameters platform) {
        this.platform = platform;
        return this;
    }

    /**
     * Get the agentConfiguration property: The machine configuration of the run agent.
     * 
     * @return the agentConfiguration value.
     */
    public AgentProperties agentConfiguration() {
        return this.agentConfiguration;
    }

    /**
     * Set the agentConfiguration property: The machine configuration of the run agent.
     * 
     * @param agentConfiguration the agentConfiguration value to set.
     * @return the TaskPropertiesUpdateParameters object itself.
     */
    public TaskPropertiesUpdateParameters withAgentConfiguration(AgentProperties agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    /**
     * Get the agentPoolName property: The dedicated agent pool for the task.
     * 
     * @return the agentPoolName value.
     */
    public String agentPoolName() {
        return this.agentPoolName;
    }

    /**
     * Set the agentPoolName property: The dedicated agent pool for the task.
     * 
     * @param agentPoolName the agentPoolName value to set.
     * @return the TaskPropertiesUpdateParameters object itself.
     */
    public TaskPropertiesUpdateParameters withAgentPoolName(String agentPoolName) {
        this.agentPoolName = agentPoolName;
        return this;
    }

    /**
     * Get the timeout property: Run timeout in seconds.
     * 
     * @return the timeout value.
     */
    public Integer timeout() {
        return this.timeout;
    }

    /**
     * Set the timeout property: Run timeout in seconds.
     * 
     * @param timeout the timeout value to set.
     * @return the TaskPropertiesUpdateParameters object itself.
     */
    public TaskPropertiesUpdateParameters withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    /**
     * Get the step property: The properties for updating a task step.
     * 
     * @return the step value.
     */
    public TaskStepUpdateParameters step() {
        return this.step;
    }

    /**
     * Set the step property: The properties for updating a task step.
     * 
     * @param step the step value to set.
     * @return the TaskPropertiesUpdateParameters object itself.
     */
    public TaskPropertiesUpdateParameters withStep(TaskStepUpdateParameters step) {
        this.step = step;
        return this;
    }

    /**
     * Get the trigger property: The properties for updating trigger properties.
     * 
     * @return the trigger value.
     */
    public TriggerUpdateParameters trigger() {
        return this.trigger;
    }

    /**
     * Set the trigger property: The properties for updating trigger properties.
     * 
     * @param trigger the trigger value to set.
     * @return the TaskPropertiesUpdateParameters object itself.
     */
    public TaskPropertiesUpdateParameters withTrigger(TriggerUpdateParameters trigger) {
        this.trigger = trigger;
        return this;
    }

    /**
     * Get the credentials property: The parameters that describes a set of credentials that will be used when this run
     * is invoked.
     * 
     * @return the credentials value.
     */
    public Credentials credentials() {
        return this.credentials;
    }

    /**
     * Set the credentials property: The parameters that describes a set of credentials that will be used when this run
     * is invoked.
     * 
     * @param credentials the credentials value to set.
     * @return the TaskPropertiesUpdateParameters object itself.
     */
    public TaskPropertiesUpdateParameters withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    /**
     * Get the logTemplate property: The template that describes the repository and tag information for run log
     * artifact.
     * 
     * @return the logTemplate value.
     */
    public String logTemplate() {
        return this.logTemplate;
    }

    /**
     * Set the logTemplate property: The template that describes the repository and tag information for run log
     * artifact.
     * 
     * @param logTemplate the logTemplate value to set.
     * @return the TaskPropertiesUpdateParameters object itself.
     */
    public TaskPropertiesUpdateParameters withLogTemplate(String logTemplate) {
        this.logTemplate = logTemplate;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (platform() != null) {
            platform().validate();
        }
        if (agentConfiguration() != null) {
            agentConfiguration().validate();
        }
        if (step() != null) {
            step().validate();
        }
        if (trigger() != null) {
            trigger().validate();
        }
        if (credentials() != null) {
            credentials().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("platform", this.platform);
        jsonWriter.writeJsonField("agentConfiguration", this.agentConfiguration);
        jsonWriter.writeStringField("agentPoolName", this.agentPoolName);
        jsonWriter.writeNumberField("timeout", this.timeout);
        jsonWriter.writeJsonField("step", this.step);
        jsonWriter.writeJsonField("trigger", this.trigger);
        jsonWriter.writeJsonField("credentials", this.credentials);
        jsonWriter.writeStringField("logTemplate", this.logTemplate);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TaskPropertiesUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TaskPropertiesUpdateParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TaskPropertiesUpdateParameters.
     */
    public static TaskPropertiesUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TaskPropertiesUpdateParameters deserializedTaskPropertiesUpdateParameters
                = new TaskPropertiesUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedTaskPropertiesUpdateParameters.status = TaskStatus.fromString(reader.getString());
                } else if ("platform".equals(fieldName)) {
                    deserializedTaskPropertiesUpdateParameters.platform = PlatformUpdateParameters.fromJson(reader);
                } else if ("agentConfiguration".equals(fieldName)) {
                    deserializedTaskPropertiesUpdateParameters.agentConfiguration = AgentProperties.fromJson(reader);
                } else if ("agentPoolName".equals(fieldName)) {
                    deserializedTaskPropertiesUpdateParameters.agentPoolName = reader.getString();
                } else if ("timeout".equals(fieldName)) {
                    deserializedTaskPropertiesUpdateParameters.timeout = reader.getNullable(JsonReader::getInt);
                } else if ("step".equals(fieldName)) {
                    deserializedTaskPropertiesUpdateParameters.step = TaskStepUpdateParameters.fromJson(reader);
                } else if ("trigger".equals(fieldName)) {
                    deserializedTaskPropertiesUpdateParameters.trigger = TriggerUpdateParameters.fromJson(reader);
                } else if ("credentials".equals(fieldName)) {
                    deserializedTaskPropertiesUpdateParameters.credentials = Credentials.fromJson(reader);
                } else if ("logTemplate".equals(fieldName)) {
                    deserializedTaskPropertiesUpdateParameters.logTemplate = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTaskPropertiesUpdateParameters;
        });
    }
}
