/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.fluent.models.DeploymentExtensionSpecProperties;
import java.io.IOException;

public final class DeploymentExtensionSpec
implements JsonSerializable<DeploymentExtensionSpec> {
    private String name;
    private DeploymentExtensionSpecProperties innerProperties;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentExtensionSpec.class);

    public String name() {
        return this.name;
    }

    public DeploymentExtensionSpec withName(String name) {
        this.name = name;
        return this;
    }

    private DeploymentExtensionSpecProperties innerProperties() {
        return this.innerProperties;
    }

    public String extensionType() {
        return this.innerProperties() == null ? null : this.innerProperties().extensionType();
    }

    public DeploymentExtensionSpec withExtensionType(String extensionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentExtensionSpecProperties();
        }
        this.innerProperties().withExtensionType(extensionType);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public DeploymentExtensionSpec withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentExtensionSpecProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public Object settings() {
        return this.innerProperties() == null ? null : this.innerProperties().settings();
    }

    public DeploymentExtensionSpec withSettings(Object settings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentExtensionSpecProperties();
        }
        this.innerProperties().withSettings(settings);
        return this;
    }

    public Object protectedSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().protectedSettings();
    }

    public DeploymentExtensionSpec withProtectedSettings(Object protectedSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentExtensionSpecProperties();
        }
        this.innerProperties().withProtectedSettings(protectedSettings);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model DeploymentExtensionSpec"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentExtensionSpec fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentExtensionSpec)jsonReader.readObject(reader -> {
            DeploymentExtensionSpec deserializedDeploymentExtensionSpec = new DeploymentExtensionSpec();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDeploymentExtensionSpec.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDeploymentExtensionSpec.innerProperties = DeploymentExtensionSpecProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentExtensionSpec;
        });
    }
}

