/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetUpdateProperties;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.AutomaticRepairsPolicy;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.PriorityMixPolicy;
import com.azure.resourcemanager.compute.models.ResiliencyPolicy;
import com.azure.resourcemanager.compute.models.ScaleInPolicy;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.SkuProfile;
import com.azure.resourcemanager.compute.models.SpotRestorePolicy;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.azure.resourcemanager.compute.models.UpgradePolicy;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetIdentity;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetUpdateVMProfile;
import com.azure.resourcemanager.compute.models.ZonalPlatformFaultDomainAlignMode;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualMachineScaleSetUpdate
extends UpdateResource {
    private Sku sku;
    private Plan plan;
    private VirtualMachineScaleSetUpdateProperties innerProperties;
    private VirtualMachineScaleSetIdentity identity;
    private List<String> zones;

    public Sku sku() {
        return this.sku;
    }

    public VirtualMachineScaleSetUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Plan plan() {
        return this.plan;
    }

    public VirtualMachineScaleSetUpdate withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    private VirtualMachineScaleSetUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public VirtualMachineScaleSetIdentity identity() {
        return this.identity;
    }

    public VirtualMachineScaleSetUpdate withIdentity(VirtualMachineScaleSetIdentity identity) {
        this.identity = identity;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public VirtualMachineScaleSetUpdate withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    @Override
    public VirtualMachineScaleSetUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public UpgradePolicy upgradePolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradePolicy();
    }

    public VirtualMachineScaleSetUpdate withUpgradePolicy(UpgradePolicy upgradePolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withUpgradePolicy(upgradePolicy);
        return this;
    }

    public AutomaticRepairsPolicy automaticRepairsPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().automaticRepairsPolicy();
    }

    public VirtualMachineScaleSetUpdate withAutomaticRepairsPolicy(AutomaticRepairsPolicy automaticRepairsPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withAutomaticRepairsPolicy(automaticRepairsPolicy);
        return this;
    }

    public VirtualMachineScaleSetUpdateVMProfile virtualMachineProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachineProfile();
    }

    public VirtualMachineScaleSetUpdate withVirtualMachineProfile(VirtualMachineScaleSetUpdateVMProfile virtualMachineProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withVirtualMachineProfile(virtualMachineProfile);
        return this;
    }

    public Boolean overprovision() {
        return this.innerProperties() == null ? null : this.innerProperties().overprovision();
    }

    public VirtualMachineScaleSetUpdate withOverprovision(Boolean overprovision) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withOverprovision(overprovision);
        return this;
    }

    public Boolean doNotRunExtensionsOnOverprovisionedVMs() {
        return this.innerProperties() == null ? null : this.innerProperties().doNotRunExtensionsOnOverprovisionedVMs();
    }

    public VirtualMachineScaleSetUpdate withDoNotRunExtensionsOnOverprovisionedVMs(Boolean doNotRunExtensionsOnOverprovisionedVMs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withDoNotRunExtensionsOnOverprovisionedVMs(doNotRunExtensionsOnOverprovisionedVMs);
        return this;
    }

    public Boolean singlePlacementGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().singlePlacementGroup();
    }

    public VirtualMachineScaleSetUpdate withSinglePlacementGroup(Boolean singlePlacementGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withSinglePlacementGroup(singlePlacementGroup);
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalCapabilities();
    }

    public VirtualMachineScaleSetUpdate withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withAdditionalCapabilities(additionalCapabilities);
        return this;
    }

    public ScaleInPolicy scaleInPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().scaleInPolicy();
    }

    public VirtualMachineScaleSetUpdate withScaleInPolicy(ScaleInPolicy scaleInPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withScaleInPolicy(scaleInPolicy);
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().proximityPlacementGroup();
    }

    public VirtualMachineScaleSetUpdate withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withProximityPlacementGroup(proximityPlacementGroup);
        return this;
    }

    public PriorityMixPolicy priorityMixPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().priorityMixPolicy();
    }

    public VirtualMachineScaleSetUpdate withPriorityMixPolicy(PriorityMixPolicy priorityMixPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withPriorityMixPolicy(priorityMixPolicy);
        return this;
    }

    public SpotRestorePolicy spotRestorePolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().spotRestorePolicy();
    }

    public VirtualMachineScaleSetUpdate withSpotRestorePolicy(SpotRestorePolicy spotRestorePolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withSpotRestorePolicy(spotRestorePolicy);
        return this;
    }

    public ResiliencyPolicy resiliencyPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().resiliencyPolicy();
    }

    public VirtualMachineScaleSetUpdate withResiliencyPolicy(ResiliencyPolicy resiliencyPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withResiliencyPolicy(resiliencyPolicy);
        return this;
    }

    public ZonalPlatformFaultDomainAlignMode zonalPlatformFaultDomainAlignMode() {
        return this.innerProperties() == null ? null : this.innerProperties().zonalPlatformFaultDomainAlignMode();
    }

    public VirtualMachineScaleSetUpdate withZonalPlatformFaultDomainAlignMode(ZonalPlatformFaultDomainAlignMode zonalPlatformFaultDomainAlignMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withZonalPlatformFaultDomainAlignMode(zonalPlatformFaultDomainAlignMode);
        return this;
    }

    public SkuProfile skuProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().skuProfile();
    }

    public VirtualMachineScaleSetUpdate withSkuProfile(SkuProfile skuProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withSkuProfile(skuProfile);
        return this;
    }

    @Override
    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("plan", (JsonSerializable)this.plan);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetUpdate)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetUpdate deserializedVirtualMachineScaleSetUpdate = new VirtualMachineScaleSetUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualMachineScaleSetUpdate.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdate.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("plan".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdate.plan = Plan.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdate.innerProperties = VirtualMachineScaleSetUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdate.identity = VirtualMachineScaleSetIdentity.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedVirtualMachineScaleSetUpdate.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetUpdate;
        });
    }
}

