/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.PrivateLinkResourceProperties;
import java.io.IOException;
import java.util.List;

public final class PrivateLinkResource
implements JsonSerializable<PrivateLinkResource> {
    private PrivateLinkResourceProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private PrivateLinkResourceProperties innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String groupId() {
        return this.innerProperties() == null ? null : this.innerProperties().groupId();
    }

    public List<String> requiredMembers() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredMembers();
    }

    public List<String> requiredZoneNames() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredZoneNames();
    }

    public PrivateLinkResource withRequiredZoneNames(List<String> requiredZoneNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkResourceProperties();
        }
        this.innerProperties().withRequiredZoneNames(requiredZoneNames);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PrivateLinkResource fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateLinkResource)jsonReader.readObject(reader -> {
            PrivateLinkResource deserializedPrivateLinkResource = new PrivateLinkResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedPrivateLinkResource.innerProperties = PrivateLinkResourceProperties.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedPrivateLinkResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPrivateLinkResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrivateLinkResource.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateLinkResource;
        });
    }
}

