/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryInner;
import com.azure.resourcemanager.compute.models.ImageVersionSecurityProfile;
import java.io.IOException;
import java.util.List;

public final class GalleryList
implements JsonSerializable<GalleryList> {
    private List<GalleryInner> value;
    private String nextLink;
    private ImageVersionSecurityProfile securityProfile;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryList.class);

    public List<GalleryInner> value() {
        return this.value;
    }

    public GalleryList withValue(List<GalleryInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public GalleryList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public ImageVersionSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public GalleryList withSecurityProfile(ImageVersionSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model GalleryList"));
        }
        this.value().forEach(e -> e.validate());
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        return jsonWriter.writeEndObject();
    }

    public static GalleryList fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryList)jsonReader.readObject(reader -> {
            GalleryList deserializedGalleryList = new GalleryList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedGalleryList.value = value = reader.readArray(reader1 -> GalleryInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedGalleryList.nextLink = reader.getString();
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedGalleryList.securityProfile = ImageVersionSecurityProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryList;
        });
    }
}

