/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetIdentityType;
import com.azure.resourcemanager.compute.models.VirtualMachineIdentityUserAssignedIdentities;
import java.io.IOException;
import java.util.Map;

public final class EncryptionSetIdentity
implements JsonSerializable<EncryptionSetIdentity> {
    private DiskEncryptionSetIdentityType type;
    private String principalId;
    private String tenantId;
    private Map<String, VirtualMachineIdentityUserAssignedIdentities> userAssignedIdentities;

    public DiskEncryptionSetIdentityType type() {
        return this.type;
    }

    public EncryptionSetIdentity withType(DiskEncryptionSetIdentityType type) {
        this.type = type;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public Map<String, VirtualMachineIdentityUserAssignedIdentities> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public EncryptionSetIdentity withUserAssignedIdentities(Map<String, VirtualMachineIdentityUserAssignedIdentities> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static EncryptionSetIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionSetIdentity)jsonReader.readObject(reader -> {
            EncryptionSetIdentity deserializedEncryptionSetIdentity = new EncryptionSetIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedEncryptionSetIdentity.type = DiskEncryptionSetIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedEncryptionSetIdentity.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedEncryptionSetIdentity.tenantId = reader.getString();
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedEncryptionSetIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> VirtualMachineIdentityUserAssignedIdentities.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionSetIdentity;
        });
    }
}

