/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.RepairAction;
import java.io.IOException;

public final class AutomaticRepairsPolicy
implements JsonSerializable<AutomaticRepairsPolicy> {
    private Boolean enabled;
    private String gracePeriod;
    private RepairAction repairAction;

    public Boolean enabled() {
        return this.enabled;
    }

    public AutomaticRepairsPolicy withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String gracePeriod() {
        return this.gracePeriod;
    }

    public AutomaticRepairsPolicy withGracePeriod(String gracePeriod) {
        this.gracePeriod = gracePeriod;
        return this;
    }

    public RepairAction repairAction() {
        return this.repairAction;
    }

    public AutomaticRepairsPolicy withRepairAction(RepairAction repairAction) {
        this.repairAction = repairAction;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("gracePeriod", this.gracePeriod);
        jsonWriter.writeStringField("repairAction", this.repairAction == null ? null : this.repairAction.toString());
        return jsonWriter.writeEndObject();
    }

    public static AutomaticRepairsPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (AutomaticRepairsPolicy)jsonReader.readObject(reader -> {
            AutomaticRepairsPolicy deserializedAutomaticRepairsPolicy = new AutomaticRepairsPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedAutomaticRepairsPolicy.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("gracePeriod".equals(fieldName)) {
                    deserializedAutomaticRepairsPolicy.gracePeriod = reader.getString();
                    continue;
                }
                if ("repairAction".equals(fieldName)) {
                    deserializedAutomaticRepairsPolicy.repairAction = RepairAction.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutomaticRepairsPolicy;
        });
    }
}

