/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.SharingProfileGroup;
import com.azure.resourcemanager.compute.models.SharingUpdateOperationTypes;
import java.io.IOException;
import java.util.List;

public final class SharingUpdateInner
implements JsonSerializable<SharingUpdateInner> {
    private SharingUpdateOperationTypes operationType;
    private List<SharingProfileGroup> groups;
    private static final ClientLogger LOGGER = new ClientLogger(SharingUpdateInner.class);

    public SharingUpdateOperationTypes operationType() {
        return this.operationType;
    }

    public SharingUpdateInner withOperationType(SharingUpdateOperationTypes operationType) {
        this.operationType = operationType;
        return this;
    }

    public List<SharingProfileGroup> groups() {
        return this.groups;
    }

    public SharingUpdateInner withGroups(List<SharingProfileGroup> groups) {
        this.groups = groups;
        return this;
    }

    public void validate() {
        if (this.operationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operationType in model SharingUpdateInner"));
        }
        if (this.groups() != null) {
            this.groups().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationType", this.operationType == null ? null : this.operationType.toString());
        jsonWriter.writeArrayField("groups", this.groups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SharingUpdateInner fromJson(JsonReader jsonReader) throws IOException {
        return (SharingUpdateInner)jsonReader.readObject(reader -> {
            SharingUpdateInner deserializedSharingUpdateInner = new SharingUpdateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationType".equals(fieldName)) {
                    deserializedSharingUpdateInner.operationType = SharingUpdateOperationTypes.fromString(reader.getString());
                    continue;
                }
                if ("groups".equals(fieldName)) {
                    List groups;
                    deserializedSharingUpdateInner.groups = groups = reader.readArray(reader1 -> SharingProfileGroup.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharingUpdateInner;
        });
    }
}

