/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetIpConfigurationProperties;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.IpVersion;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetPublicIpAddressConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VirtualMachineScaleSetIpConfiguration {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="properties")
    private VirtualMachineScaleSetIpConfigurationProperties innerProperties;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetIpConfiguration.class);

    public String name() {
        return this.name;
    }

    public VirtualMachineScaleSetIpConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    private VirtualMachineScaleSetIpConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public ApiEntityReference subnet() {
        return this.innerProperties() == null ? null : this.innerProperties().subnet();
    }

    public VirtualMachineScaleSetIpConfiguration withSubnet(ApiEntityReference subnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetIpConfigurationProperties();
        }
        this.innerProperties().withSubnet(subnet);
        return this;
    }

    public Boolean primary() {
        return this.innerProperties() == null ? null : this.innerProperties().primary();
    }

    public VirtualMachineScaleSetIpConfiguration withPrimary(Boolean primary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetIpConfigurationProperties();
        }
        this.innerProperties().withPrimary(primary);
        return this;
    }

    public VirtualMachineScaleSetPublicIpAddressConfiguration publicIpAddressConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddressConfiguration();
    }

    public VirtualMachineScaleSetIpConfiguration withPublicIpAddressConfiguration(VirtualMachineScaleSetPublicIpAddressConfiguration publicIpAddressConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetIpConfigurationProperties();
        }
        this.innerProperties().withPublicIpAddressConfiguration(publicIpAddressConfiguration);
        return this;
    }

    public IpVersion privateIpAddressVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().privateIpAddressVersion();
    }

    public VirtualMachineScaleSetIpConfiguration withPrivateIpAddressVersion(IpVersion privateIpAddressVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetIpConfigurationProperties();
        }
        this.innerProperties().withPrivateIpAddressVersion(privateIpAddressVersion);
        return this;
    }

    public List<SubResource> applicationGatewayBackendAddressPools() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationGatewayBackendAddressPools();
    }

    public VirtualMachineScaleSetIpConfiguration withApplicationGatewayBackendAddressPools(List<SubResource> applicationGatewayBackendAddressPools) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetIpConfigurationProperties();
        }
        this.innerProperties().withApplicationGatewayBackendAddressPools(applicationGatewayBackendAddressPools);
        return this;
    }

    public List<SubResource> applicationSecurityGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationSecurityGroups();
    }

    public VirtualMachineScaleSetIpConfiguration withApplicationSecurityGroups(List<SubResource> applicationSecurityGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetIpConfigurationProperties();
        }
        this.innerProperties().withApplicationSecurityGroups(applicationSecurityGroups);
        return this;
    }

    public List<SubResource> loadBalancerBackendAddressPools() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancerBackendAddressPools();
    }

    public VirtualMachineScaleSetIpConfiguration withLoadBalancerBackendAddressPools(List<SubResource> loadBalancerBackendAddressPools) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetIpConfigurationProperties();
        }
        this.innerProperties().withLoadBalancerBackendAddressPools(loadBalancerBackendAddressPools);
        return this;
    }

    public List<SubResource> loadBalancerInboundNatPools() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancerInboundNatPools();
    }

    public VirtualMachineScaleSetIpConfiguration withLoadBalancerInboundNatPools(List<SubResource> loadBalancerInboundNatPools) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetIpConfigurationProperties();
        }
        this.innerProperties().withLoadBalancerInboundNatPools(loadBalancerInboundNatPools);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model VirtualMachineScaleSetIpConfiguration"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

