/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.GalleryImageVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryImageVersionSafetyProfile;
import com.azure.resourcemanager.compute.models.GalleryImageVersionStorageProfile;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.ImageVersionSecurityProfile;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class GalleryImageVersionProperties {
    @JsonProperty(value="publishingProfile")
    private GalleryImageVersionPublishingProfile publishingProfile;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private GalleryProvisioningState provisioningState;
    @JsonProperty(value="storageProfile", required=true)
    private GalleryImageVersionStorageProfile storageProfile;
    @JsonProperty(value="safetyProfile")
    private GalleryImageVersionSafetyProfile safetyProfile;
    @JsonProperty(value="replicationStatus", access=JsonProperty.Access.WRITE_ONLY)
    private ReplicationStatus replicationStatus;
    @JsonProperty(value="securityProfile")
    private ImageVersionSecurityProfile securityProfile;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryImageVersionProperties.class);

    public GalleryImageVersionPublishingProfile publishingProfile() {
        return this.publishingProfile;
    }

    public GalleryImageVersionProperties withPublishingProfile(GalleryImageVersionPublishingProfile publishingProfile) {
        this.publishingProfile = publishingProfile;
        return this;
    }

    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public GalleryImageVersionStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public GalleryImageVersionProperties withStorageProfile(GalleryImageVersionStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public GalleryImageVersionSafetyProfile safetyProfile() {
        return this.safetyProfile;
    }

    public GalleryImageVersionProperties withSafetyProfile(GalleryImageVersionSafetyProfile safetyProfile) {
        this.safetyProfile = safetyProfile;
        return this;
    }

    public ReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    public ImageVersionSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public GalleryImageVersionProperties withSecurityProfile(ImageVersionSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public void validate() {
        if (this.publishingProfile() != null) {
            this.publishingProfile().validate();
        }
        if (this.storageProfile() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageProfile in model GalleryImageVersionProperties"));
        }
        this.storageProfile().validate();
        if (this.safetyProfile() != null) {
            this.safetyProfile().validate();
        }
        if (this.replicationStatus() != null) {
            this.replicationStatus().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }
}

