/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.WafRankingsResponseDataItemMetric;
import java.io.IOException;
import java.util.List;

public final class WafRankingsResponseDataItem
implements JsonSerializable<WafRankingsResponseDataItem> {
    private List<String> groupValues;
    private List<WafRankingsResponseDataItemMetric> metrics;

    public List<String> groupValues() {
        return this.groupValues;
    }

    public WafRankingsResponseDataItem withGroupValues(List<String> groupValues) {
        this.groupValues = groupValues;
        return this;
    }

    public List<WafRankingsResponseDataItemMetric> metrics() {
        return this.metrics;
    }

    public WafRankingsResponseDataItem withMetrics(List<WafRankingsResponseDataItemMetric> metrics) {
        this.metrics = metrics;
        return this;
    }

    public void validate() {
        if (this.metrics() != null) {
            this.metrics().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("groupValues", this.groupValues, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("metrics", this.metrics, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WafRankingsResponseDataItem fromJson(JsonReader jsonReader) throws IOException {
        return (WafRankingsResponseDataItem)jsonReader.readObject(reader -> {
            WafRankingsResponseDataItem deserializedWafRankingsResponseDataItem = new WafRankingsResponseDataItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("groupValues".equals(fieldName)) {
                    List groupValues;
                    deserializedWafRankingsResponseDataItem.groupValues = groupValues = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    List metrics;
                    deserializedWafRankingsResponseDataItem.metrics = metrics = reader.readArray(reader1 -> WafRankingsResponseDataItemMetric.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWafRankingsResponseDataItem;
        });
    }
}

